# CVE-2025-27237

Local privilege escalation vulnerability in Zabbix Agent/Agent2 for Windows via OpenSSL configuration file hijacking.

## Overview

| Field | Value |
|-------|-------|
| **CVE ID** | CVE-2025-27237 |
| **CVSS v4.0** | 7.3 (HIGH) |
| **CWE** | CWE-427: Uncontrolled Search Path Element |
| **Type** | Local Privilege Escalation |
| **Vendor** | Zabbix |

Zabbix Agent for Windows loads OpenSSL configuration from a hardcoded path (`C:\vcpkg\...`) that is writable by low-privileged users. An attacker can plant a malicious `openssl.cnf` that loads an arbitrary DLL with SYSTEM privileges when the Zabbix Agent service restarts.

## Affected Versions

| Branch | Affected | Fixed |
|--------|----------|-------|
| 6.0 LTS | 6.0.0 - 6.0.40 | 6.0.41 |
| 7.0 | 7.0.0 - 7.0.17 | 7.0.18 |
| 7.2 | 7.2.0 - 7.2.11 | 7.2.12 |
| 7.4 | 7.4.0 - 7.4.1 | 7.4.2 |

## Repository Contents

```
.
├── CVE-2025-27237-analysis.md   # Detailed technical analysis
├── CVE-2025-27237-PoC.md        # Proof of concept documentation
├── extract_openssl_paths.py     # Binary analysis tool
├── poc.c                        # PoC DLL source (MessageBox)
├── poc2.c                       # PoC DLL variant (file write)
└── poc3.c                       # PoC DLL variant
```

## Usage

### Analyze Zabbix Binaries

Extract hardcoded OpenSSL paths from Zabbix Agent binaries to determine vulnerability status:

```bash
python extract_openssl_paths.py zabbix_agent2.exe
```

The script uses `strings` and optionally `radare2` to find:
- `OPENSSLDIR` - Location of openssl.cnf
- `ENGINESDIR` - Location for OpenSSL engines
- `MODULESDIR` - Location for OpenSSL modules

### Compile PoC DLL (MinGW)

For 32-bit (i386) Zabbix Agent:
```bash
i686-w64-mingw32-gcc -shared -o poc.dll poc.c -luser32
```

For 64-bit (amd64) Zabbix Agent:
```bash
x86_64-w64-mingw32-gcc -shared -o poc.dll poc.c -luser32
```

## Download Vulnerable Agents

Vulnerable versions of Zabbix Agent can be downloaded from the official archive:
https://www.zabbix.com/download_agents

## Exploitation Requirements

1. Local user access to Windows system
2. Zabbix Agent configured with TLS (`TLSConnect=cert` or `TLSAccept=cert`)
3. Ability to create directories at `C:\` root (default Windows permissions)
4. Service restart (or system reboot)

## Detection

Check for exploitation attempts:
```powershell
Test-Path "C:\vcpkg\downloads\tools\msys2\*\etc\ssl\openssl.cnf"
```

## Remediation

Upgrade to patched versions:
- 6.0.41+, 7.0.18+, 7.2.12+, or 7.4.2+

## References

- [NVD - CVE-2025-27237](https://nvd.nist.gov/vuln/detail/CVE-2025-27237)
- [Zabbix Support - ZBX-27061](https://support.zabbix.com/browse/ZBX-27061)
- [GitHub Advisory - GHSA-r6x3-vwpm-5vwg](https://github.com/advisories/GHSA-r6x3-vwpm-5vwg)

## Credits

- Original discovery: himbeer (via HackerOne)
- Analysis: Independent verification performed January 2026
