# TSplus Remote Access - CVE-2025-26318 (Insecure Permissions Information Disclosure)

## 📌 Description
TSplus is, by default, vulnerable to the disclosure of information from users currently connected to the domain on TSplus.

### 🔍 Vulnerability Details
- **CVE ID**: [CVE-2025-26318](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-26318)
- **Vendor**: [TSplus](https://tsplus.net)
- **Affected Versions**: TSplus Remote Access **< v17.30**
- **Vulnerability Type**: Insecure Permissions
- **Impact**: Information Disclosure
- **Attack Vector**: Remote (Unauthenticated HTTP request)

---

## 🚨 Risks
This vulnerability allows attackers to retrieve a **list of all domain accounts** currently connected to the application.  
This can have **serious consequences**, providing a wealth of exploitable information for **highly targeted phishing or vishing attacks**.

---

## 🚀 Proof of Concept (PoC)
This repository contains a **script** that exploits the TSplus vulnerability.  
It retrieves connected users at **regular intervals** and logs them uniquely into a file to maximize the number of valid users captured from the domain.

📂 **PoC File:** [`exploit.py`](./Tscrap.py)  

### 📸 PoC Execution Screenshots:
![image](https://github.com/user-attachments/assets/6d4b580b-971b-422a-9ff0-3d0cec6d0fce)

![image](https://github.com/user-attachments/assets/fc0bff85-46e1-4e36-842c-8b58e4e2ae42)

---

## 🔥 Impact
Attackers can exploit this flaw to:
- **Retrieve a list of all domain accounts** logged into the TSplus instance.
- Use this information for **further attacks** such as phishing or credential stuffing.
- Gain reconnaissance data for **targeted intrusions**.

---

## ✅ Remediation

Following responsible disclosure, the TSplus development team addressed this vulnerability.📌 As of October 30, 2024, the vendor has implemented the following fix:

The /cgi-bin/hb.exe endpoint no longer lists usernames.

A new dedicated API endpoint was introduced: /api/loadbalancing/load on port 19955.

This new endpoint requires signed messages with a timestamp for authentication.

Vendor Confirmation (October 30, 2024):

>"We have removed the user listing from the endpoint /cgi-bin/hb.exe. A new dedicated endpoint /api/loadbalancing/load on port 19955 has been implemented, which requires signed messages with a timestamp. The fix is available in the beta version of Remote Access."
---

## 🗓 Disclosure Timeline
- **[Septembre 2024]**: Vulnerability discovered.
- **[16 oct. 2024]**: Reported to editor.
- **[24 oct. 2024]**: Vendor confirmed the issue.
- **[30 octobre 2024]**: Patch released in beta.
- **[28/02/2025]**: Public disclosure.

---

## 📜 References
- [CVE-2025-26318](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-26318)
- [TSplus Official Website](https://tsplus.net)

---

### ⚠ Disclaimer
This PoC is intended for **educational and research purposes only**.  
**Do not exploit systems without explicit permission.**  

---

💡 **If you find this useful, consider starring the repo!** ⭐  
