# CVE-2025-26244-POC
The code to exploit this vulnerability can be seen in 'spoof.go'. This imitates as an agent to the C2 server. In order to run this vulnerability we need to know:

1. The listener IP address and Port
2. The public key of the listener.
3. The first time check in URL of the listener.

We could obtain this information by reverse engineering a binary previously generated by the operator.

Currently, 'spoof.go' only works when both the listener and agent use the HTTPS protocol, however, if adapted this will likely work with the other protocols DeimosC2 supports.

## To Exploit
1) You will need access to a HTTPS binary previously generated by the operator. 

2) Extract the IP address, port, the public key and first time check in URL of the listener from the binary. [Trend Micro](https://www.trendmicro.com/en_us/research/22/k/deimosc2-what-soc-analysts-and-incident-responders-need-to-know.html) provide scripts to aid in this.
3) Place the IP address, port, the public key and first time check in URL of the listener into the script.
4) Install the DeimosC2 Crypto Library

```go
go install github.com/DeimosC2/DeimosC2/lib/crypto@latest
```

5) Run the script.
```go
go run Spoof.go
```
6) A new agent will be registered and as soon as the operator loads the graph view the XSS will trigger and you will have their cookie!

*If you only have access to a binary with one of the other protocols, spoof.go will need to be adapted to support the other protocols.*

# Writeup
A full writeup on how I discovered this vulnerability can be seen on my blog [here](https://jarm222.github.io/posts/CVE-2025-26244-Writeup/).

# Video PoC
https://github.com/user-attachments/assets/b6e475b2-600d-40ce-bdfa-5bfe9ff3d682







