# 🛡️ CVE Disclosure: CVE-2025-26198 — SQL Injection in CloudClassroom-PHP-Project

**Disclosure Date:** 18 June 2025  
**CVE ID:** CVE-2025-26198  
**Severity:** CRITICAL (CVSS 9.8)

---

## 🧩 Summary

A critical SQL Injection vulnerability exists in `CloudClassroom-PHP-Project v1.0`, specifically within the `loginlinkadmin.php` endpoint. The application directly incorporates unsanitized user inputs into SQL queries, allowing unauthenticated attackers to bypass authentication and gain full administrative access.

This issue has been assigned the identifier **CVE-2025-26198**. At the time of public disclosure, **no official patch** was available.

---

## 📦 Affected Product

- **Vendor:** Independent (mathurvishal)
- **Project:** [CloudClassroom-PHP-Project](https://github.com/mathurvishal/CloudClassroom-PHP-Project)
- **Version:** v1.0
- **File:** `loginlinkadmin.php`
- **Vulnerable Endpoint:**  
  `http://localhost/CloudClassroom-PHP-Project-master/loginlinkadmin.php`

---

## 🔬 Vulnerability Details

The admin login mechanism uses unsanitized input directly in SQL queries without any input validation or prepared statements:

```php
$query = "SELECT * FROM admin WHERE username='$username' AND password='$password'";
```

This allows for injection payloads such as:

```sql
Username: ' OR '1'='1
Password: [any value]
```

This bypasses authentication logic by evaluating to a true condition, thereby granting access to the admin dashboard.

---

## 📌 CWE Classification

| CWE ID | Title                                                                 |
|--------|-----------------------------------------------------------------------|
| [CWE-89](https://cwe.mitre.org/data/definitions/89.html) | Improper Neutralization of Special Elements used in an SQL Command |

---

## 📊 CVSS v3.1 Score

| Score | Severity | Vector String                              |
|-------|----------|---------------------------------------------|
| 9.8   | CRITICAL | `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H` |

---

## 💥 Impact

A successful exploitation could result in:

- ✅ Full **authentication bypass**
- 🔓 **Unauthorized access** to privileged admin features
- 🛠️ Potential **data leakage or manipulation** using `UNION`-based SQL injection
- ⚠️ Full **compromise of the backend database**

---

## 🧪 Proof of Concept (PoC)

### 1. Clone the Repository

```bash
git clone https://github.com/mathurvishal/CloudClassroom-PHP-Project.git
```

### 2. Host Locally

Use XAMPP/LAMP to deploy the project and navigate to:

```
http://localhost/CloudClassroom-PHP-Project-master/loginlinkadmin.php
```

### 3. Payload Injection

Enter the following credentials in the login form:

- **Username:** `' OR '1'='1`
- **Password:** `[any value]`

You will be logged in as the first admin user, verifying successful SQL injection.

---

## 🔐 Recommendations

- ✅ Replace dynamic SQL queries with **prepared statements** (`mysqli_prepare()` or **PDO**).
- 🔍 Perform **input validation and sanitization** for all user inputs.
- 🧱 Deploy a **Web Application Firewall (WAF)** to block known SQL injection patterns.
- 🛡️ Conduct **regular code audits** and **penetration testing** for early detection.

---

## 📆 Timeline

| Event                    | Date           |
|--------------------------|----------------|
| Vulnerability Discovered | 14 April 2025  |
| Public Disclosure        | 18 June 2025   |
| Patch Available          | ❌ Not available as of disclosure |

---

## 🙋‍♂️ Credits

This vulnerability was discovered and responsibly disclosed by:

**Tansique Dasari**  
🔗 [GitHub](https://github.com/phantomtrace)  
✉️ [tansique.d@gmail.com](mailto:tansique.d@gmail.com)

---

## 🔗 References

- [OWASP - SQL Injection](https://owasp.org/www-community/attacks/SQL_Injection)
- [PortSwigger - SQL Injection](https://portswigger.net/web-security/sql-injection)
- [CVE-2025-26198 on CVE.org](https://cve.org/CVERecord?id=CVE-2025-26198)

---

> 💬 *This advisory is published independently due to lack of vendor response.*
