# CVE-2025-26055
CVE Description

# Author : Rohan Deshpande

# OS Command Injection

# Summary 
OS command injection is a security vulnerability that allows an 
attacker to execute arbitrary commands on a host operating system 
via a vulnerable application. This can lead to unauthorized access, 
data breaches, and system compromise.

# Impact 
The impact of OS command injection can include unauthorized 
access to system resources, data theft, system compromise, and 
potential full control over the affected server, leading to severe 
security breaches and operational disruptions.

# Affected URL 
```http://<ip>:<port>/generateTrackRoute```

# Recommendation 
To mitigate OS command injection vulnerabilities, validate and 
sanitize all user inputs, use parameterized commands or APIs, and 
implement least privilege principles to limit the execution context of 
applications. Regular security testing and code reviews are also 
essential to identify and remediate potential weaknesses. 

# Proof of Concept
1. Login to the console and navigate to Troubleshoot → Tracert.
2. Enter IP and restriction bypass payload ‘&lt;!--#exec%20cmd=&quot;/usr/bin/id;--&gt;’. Notice the result.
3. Capture the request and try to fetch ‘&lt;!--#exec%20cmd=&quot;/bin/cat%20/etc/passwd&quot;--&gt;’ file through tracertVal
parameter and notice file displayed in HTTP response
