# CVE-2025-26054
CVE-2025-26054

# Author: Rohan Deshpande

# Stored Cross Site Scripting
# Summary 
Stored XSS (Cross-Site Scripting) is a security vulnerability that 
occurs when an attacker injects malicious scripts into a web 
application, which are then stored on the server and served to users. 
When users access the affected content, the script executes in their 
browsers, potentially leading to data theft, session hijacking, and 
unauthorized actions. This type of attack can have severe 
consequences for both users and the integrity of the web application.

# Severity
High

# Impact
The impact of Stored XSS can be severe, as it allows attackers to 
execute malicious scripts in the browsers of users who visit the 
compromised page. This can lead to data theft, such as capturing 
sensitive information (e.g., cookies, login credentials), session 
hijacking, and unauthorized actions on behalf of the user. 

# Affected URL 
```http://<ip>:<port>/index ```

# Recommendation
To mitigate Stored XSS vulnerabilities, implement proper input 
validation and output encoding to ensure that user-supplied data is 
treated as data, not executable code. Use security libraries and 
frameworks that automatically handle XSS protection, and employ 
Content Security Policy (CSP) to restrict the execution of scripts. 
Regular security testing and code reviews are also essential to 
identify and remediate potential weaknesses. 

# Proof of Concept
1. Login to the console and navigate to Network → LAN.
2. Fill the necessary details and capture the request on burp.
3. Inject a simple payload like ```"`'><script>\x0Bjavascript:alert(1)</script>```
into the description parameter.
4. Forward it and Navigate to summary. Notice XSS triggered.
