# CVE-2025-25747 - Reflected XSS Vulnerability in HotelDruid 3.0.7

## Description

Cross Site Scripting vulnerability in DigitalDruid HotelDruid v.3.0.7 allows an attacker to execute arbitrary code and obtain sensitive information via the ripristina_backup parameter in the crea_backup.php endpoint

---

## Severity & Impact

### Impact

An attacker could trick an authenticated user into visiting a crafted URL, which would trigger malicious JavaScript in their browser. Potential consequences include:

- **Session Hijacking:** An attacker could steal session cookies, gaining unauthorized access to the user’s account.
- **Phishing or Malware Delivery:** The user could be redirected to malicious websites, or attacker-controlled scripts could inject malicious content directly into the interface.
- **Abuse of Administrative Privileges:** If exploited against an administrator, the attacker could potentially modify system settings or manipulate sensitive data.

---

## Proof of Concept (PoC)

### PoC 1 - Alert Injection

```
http://localhost/hoteldruid/crea_backup.php?anno=2025&id_sessione=<valid_session_id>&azione=SI&ripristina_backup=%22%3E%3CscrIpt%3Ealert%28%27Huy%20Vo%20Found%20This%20Vulnerability%27%29%3B%3C%2FscrIpt%3E&dati_conn=attuali&mantieni_anni=1
```

**Result:** A popup alert with the message “Huy Vo Found This Vulnerability” confirms successful XSS execution.

### PoC 2 - External Redirection

```
http://localhost/hoteldruid/crea_backup.php?anno=2025&id_sessione=<valid_session_id>&azione=SI&ripristina_backup="><scrIpt>window.location.href='https://www.facebook.com';</scrIpt>&dati_conn=attuali&mantieni_anni=1
```

**Result:** Browser automatically redirects to Facebook.

---

## Analysis

### Background

HotelDruid is an open-source property management system used to manage reservations, rooms, and invoicing for hotels, B&Bs, and other hospitality businesses. It is web-based, typically installed on local servers and accessed via browser. Given its web interface and administrative nature, strong security is crucial — especially for authenticated functions.

---

## Vulnerability Details

The `crea_backup.php` endpoint processes the `ripristina_backup` parameter without sanitization or encoding, directly reflecting user input into the page. This allows an attacker to craft a malicious URL that injects arbitrary JavaScript into the page rendered for an authenticated user.

### Key Technical Details

- **Affected Parameter:** `ripristina_backup`
- **Affected Endpoint:** `crea_backup.php`
- **Attack Type:** Reflected Cross-Site Scripting (XSS)
- **Precondition:** Requires a valid authenticated session (`id_sessione`)

### Attack Flow

1. Attacker crafts a malicious URL with the payload injected into `ripristina_backup`.
2. Attacker sends this URL to an authenticated victim (e.g., via phishing email, chat message).
3. Victim clicks the URL while authenticated, triggering the malicious JavaScript in their browser.
4. The script executes with the victim’s session context, enabling:
    - **Session cookie theft** (if HttpOnly is not set)
    - **Redirection to attacker-controlled sites**
    - **Injection of malicious content into the interface**

---

## Mitigation / Patching

### Recommendations for Developers

- **Input Validation:** Validate all user-supplied input on the server-side.
- **Output Encoding:** Properly encode all output before rendering (e.g., use `htmlspecialchars()` in PHP to encode `<` and `>` characters).
- **Content Security Policy (CSP):** Implement a strict Content Security Policy to reduce the impact of injected scripts.
- **Session Management:** Ensure sessions are not exposed in GET parameters (use secure cookies with HttpOnly and SameSite flags).

---

## Timeline and Credits

- **Discovery Date:** Januart 16, 2025
- **Vendor Notification:** January 17, 2025
- **MITRE CVE Assignment:** CVE-2025-25747, February 27 2025
- **Public Disclosure:** March 7, 2025
- **Researcher:** Huy Vo (Security Researcher)
