# 📌 CVE-2025-25461 - Stored Cross-Site Scripting (XSS) in SeedDMS 6.0.29

## 📝 Description
A Stored Cross-Site Scripting (XSS) vulnerability exists in **SeedDMS 6.0.29**.  
A user or rogue admin with the **"Add Category"** permission can inject a malicious XSS payload into the category name field.  
When a document is subsequently associated with this category, the payload is stored on the server and rendered without proper sanitization or output encoding.  
This results in the XSS payload executing in the browser of any user who views the document.

## 🎯 Affected Product
- **Software:** SeedDMS
- **Version:** 6.0.29
- **Component:** Category Name Field

## ⚠️ Impact
- **Session Hijacking**
- **Data Exfiltration**
- **Phishing Attacks**
- **Remote Code Execution (via JavaScript)**

## 🔥 Proof of Concept (PoC)
### Steps to Reproduce:
1. Log in as a user with **"Add Category"** permissions.
2. Navigate to **Admin Panel > Categories**.
3. Create a new category with the following payload:
   ```html
   <script>alert(1)</script>
   ```
4. Save the category.
5. Associate a document with the malicious category.
6. When a user views the document, the payload executes in their browser.

### 📹 Video PoC:
🔗 [Watch Video PoC](https://drive.google.com/file/d/1QV9nyXnid1QigYAYzvCeRtUGSl35AbuG/view?usp=drive_link)

## 🛠️ Mitigation
- **Sanitize User Input**: Escape special characters in category names.
- **Use Content Security Policy (CSP)**: Prevent inline script execution.
- **Encode Output**: Ensure category names are properly encoded before rendering in the UI.

## 🔗 Reference
- 🔗 [SeedDMS Official Website](https://www.seeddms.org/)
- 🔗 [SeedDMS Discussion Thread](https://sourceforge.net/p/seeddms/discussion/general/thread/eb4ce9b1ff/)

✍️ Discoverer

## ✍️ Discoverer
- **Athul S**  
  - 🔗 [Linkedin](https://www.linkedin.com/in/athul-s-pentester/)
  - 🔗 [GitHub](https://github.com/RoNiXxCybSeC0101)

## 🏷️ CVE Assignment
- **CVE ID:** CVE-2025-25461

