# FlatPress CMS Stored XSS in v1.3.1  
**CVE-2025-25460**  
**Author:** Athul S  

## Description  
A stored Cross-Site Scripting (XSS) vulnerability was identified in **FlatPress 1.3.1** within the "Add Entry" feature. This vulnerability allows **authenticated attackers** to inject malicious JavaScript payloads into blog posts, which execute when other users view the posts. The issue arises due to **improper input sanitization** of the **"TextArea" field** in the blog entry submission form.

## Attack Vectors  
- An **authenticated attacker** can inject a malicious **JavaScript payload** into the blog post entry.  
- The payload executes when an **admin or another user** visits the affected blog entry.  
- This could lead to **session hijacking, phishing, or other client-side attacks**.

## Proof of Concept (PoC)  

### Steps to Reproduce:  
1. **Login as an Admin** in FlatPress v1.3.1.  
2. Navigate to the **"Add Entry"** section.  
3. Insert the following **XSS payload** in the text area:  

   ```html
   <script>alert('XSS Payload Triggered');</script>
   ```
4. Save the Entry and View the Post

The JavaScript payload will execute when the page loads, triggering an **XSS alert box**.  

   


![Screenshot 2025-02-21 094902](https://github.com/user-attachments/assets/2559bfba-8b4b-4a1c-b6b1-f11eb9637743)

![Screenshot 2025-02-21 094915](https://github.com/user-attachments/assets/557a86fa-0cfe-462e-938b-c762abfbdfe0)

![Screenshot 2025-02-21 095029](https://github.com/user-attachments/assets/f17be1ca-52b4-4dd8-af48-6d7eed0523fc)

![Screenshot 2025-02-21 095046](https://github.com/user-attachments/assets/1d10f62a-797b-461d-8efb-b28ca8fa04fe)

![Screenshot 2025-02-21 095059](https://github.com/user-attachments/assets/b98c25e7-15e7-4192-8968-ba718113d68c)


## Impact  
- **Code Execution:** ✅ *(JavaScript execution in the victim's browser)*  
- **Potential Exploits:**  
  - **Session Hijacking** (stealing admin cookies).  
  - **Phishing Attacks** (redirecting users to malicious sites).  
  - **Defacement** (injecting unwanted content into the page).  

## Affected Product  
- **Product:** FlatPress  
- **Version:** 1.3.1  
- **Component:** Add Entry Feature (TextArea Field)  

## Mitigation  
- **Sanitize user inputs** before rendering.  
- **Implement Content Security Policy (CSP)** to block inline scripts.  
- **Update to FlatPress 1.4-dev**, where the issue is patched.  

## Vendor Contact  
- Contacted via email:  
  - [hello@flatpress.org](mailto:hello@flatpress.org)  
  - [frank.pcn@gmail.com](mailto:frank.pcn@gmail.com)  
- Vendor **confirmed** the issue on **January 12, 2025**.  
- The vulnerability is being patched in the **FlatPress 1.4-dev branch**.  

## References  
- [FlatPress Official Website](https://www.flatpress.org/)  
- [FlatPress GitHub Repository](https://github.com/flatpressblog/flatpress)  

## Discoverer  
**Athul S**  
