# CVE-2025-25062

- [Description](#description)
- [Usage](#usage)
- [Example](#example)
- [Timeline](#timeline)

## Description
A Stored Cross-Site-Scripting (XSS) vulnerability exists in the [Backdrop CMS 1.29.2](https://github.com/backdrop/backdrop/releases/tag/1.29.2) post edit page. This script chains the vulnerability with a CSRF payload to achieve privilege escalation from the role of 'Editor' to 'Administrator'.

Relevant links:
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-25062
- https://backdropcms.org/security/backdrop-sa-core-2025-001
  
## Usage

```
usage: CVE-2025-25062.py [-h] [-u BACKDROP_URL] --editor-username EDITOR_USERNAME --editor-password EDITOR_PASSWORD [--post-title POST_TITLE]
                          [--post-html-body POST_HTML_BODY] [--proxy-host PROXY_HOST] [--proxy-port PROXY_PORT]

options:
  -h, --help            show this help message and exit
  -u BACKDROP_URL, --backdrop-url BACKDROP_URL
  --editor-username EDITOR_USERNAME
  --editor-password EDITOR_PASSWORD
  --post-title POST_TITLE
  --post-html-body POST_HTML_BODY
  --proxy-host PROXY_HOST
  --proxy-port PROXY_PORT
```

## Example

1. Observe the inital permissions of the `editor` and `admin` users.
   
![image](https://github.com/user-attachments/assets/034bd5a0-2470-41fa-bdde-29b1b72437cd)

2. Run the `CVE-2025-25062.py` script, providing the username and password for the user with permissions of `Editor`.

![image](https://github.com/user-attachments/assets/27eff287-1a22-4f1f-9b07-6ddbe5dffa11)

3. Log in as the `admin` user and browse to the link output by the script.

![image](https://github.com/user-attachments/assets/1180aeb4-5627-44f6-9ebf-09ddbe39a95e)

4. Observe the new `Administrator` permission on the `editor` user.

![image](https://github.com/user-attachments/assets/9cd52f60-9cff-4cf2-a705-a1e229bc121e)

## Timeline
- 2024-12-14: Discovered and reported to Backdrop Security Team.
- 2024-12-15: Acknowledged by Backdrop Security Team. Fix scheduled for early January.
- 2025-01-06: Patch validated.
- 2025-01-08: Security update 1.29.3 released.
- 2025-02-03: CVE-2025-25062 assigned.
