


# CVE-2025-24799 SQLi Scanner

A fast SQL injection vulnerability scanner built with Python. Uses time-based SQLi detection with multithreading and colorful output, designed for testing CVE-2025-24799 vulnerabilities.

---

## Features
- Scans single URLs or lists from files
- Shows vulnerable URLs live as they're found
- Multithreaded for speed
- Colorful CLI output
- Option to save results

---

## Installation

1. Clone the repo:
   ```bash
   git clone https://github.com/MuhammadWaseem29/CVE-2025-24799.git
   cd CVE-2025-24799
   ```

2. Install required packages:
   ```bash
   pip install requests colorama
   ```

---

## Usage

Run with Python 3:

### Scan a Single URL
```bash
python3 exploit.py -u http://example.com
```
Output:
```
[VULN] http://example.com/index.php/ajax/ - Delay: 7.40s
```

### Scan URLs from a File
```bash
python3 exploit.py -f urls.txt -t 15
```
Output:
```
Scanning: 100/1000 (10.0%)
[VULN] http://example.com/index.php/ajax/ - Delay: 7.10s
```

### Save Results to a File
```bash
python3 exploit.py -f urls.txt -o results.txt -t 10
```
Output:
```
Scanning: 50/500 (10.0%)
[VULN] http://test.com/index.php/ajax/ - Delay: 7.20s
[+] Results saved to results.txt
```
![image](https://github.com/user-attachments/assets/1960c2e0-0101-4663-82bd-2e71ed71b4be)

Validate via curl 

![image](https://github.com/user-attachments/assets/710df31f-3bde-4538-a72a-f9fe093414a0)


### Options
- `-u <URL>`: Single URL to scan
- `-f <FILE>`: File with URLs (one per line)
- `-o <FILE>`: Save results to file
- `-t <NUM>`: Number of threads (default: 10)

---

## Sample Output
```
╔════════════════════════════╗
║ Noob-Wasi SQLi Scanner    ║
║ Coded by: Noob-Wasi       ║
║ Version: 1.0             ║
╚════════════════════════════╝

Starting SQL injection scan...
Scanning: 200/3494 (5.7%)
[VULN] http://152.67.42.99/index.php/ajax/ - Delay: 7.40s
Scanning: 745/3494 (21.3%)

Scan completed!
```

---

## Notes
- Requires Python 3.x
- Test only on systems you have permission to scan
- Adjust threads (`-t`) based on your system/network

---

**Author**: Noob-Wasi  
**GitHub**: [github.com/MuhammadWaseem29](https://github.com/MuhammadWaseem29)
```
