# 🔥 CVE-2025-24514 원격 취약점 점검 PoC

이 스크립트는 CVE-2025-24514 취약점(ingress-nginx의 `auth-url` 주입을 통한 NGINX 설정 조작 및 RCE 가능성)에 대해 **원격으로 점검**할 수 있는 Python 기반 PoC입니다.

---

## 🧠 취약점 개요

- **CVE-2025-24514**는 Kubernetes Ingress Controller 중 `ingress-nginx`에서 `nginx.ingress.kubernetes.io/auth-url` 어노테이션을 통해 **NGINX 설정이 의도치 않게 주입**되는 취약점입니다.
- 악의적인 경로(`/;error_log /dev/stdout;`)를 포함하면 NGINX 설정 파일이 변조되어 **임의 명령 실행 또는 정보 유출**이 가능합니다.

---

## ✅ PoC 주요 기능

- 대상 서버에 HTTP 요청을 전송하여 `auth-url` 설정 주입 시도
- 응답 내 `error_log`, `auth-url` 문자열 존재 여부로 **취약 여부 판별**
- Windows CMD, PowerShell, Linux/Bash 호환
- `colorama`를 통한 색상 출력 지원

---

## 📦 설치 및 실행 방법

### 1. Python 설치

Python 3.x 환경이 필요합니다.

### 2. 의존 패키지 설치

bash
pip install requests colorama```

### 3. PoC 실행
bash
python cve_2025_24514_remote_poc.py

---

## 🖥️ 실행 예시
[=] CVE-2025-24514 원격 취약점 점검 PoC 시작 =

[?] 대상 서버 URL/IP를 입력하세요 (예: http://192.168.0.0): http://192.168.0.0
[+] 대상에 악성 요청 전송 중: http://192.168.0.0
[+] HTTP 응답 코드: 200
[+] 응답 내용 (앞 300자):
<html><body>Welcome...</body></html>
[!!!] 취약 가능성이 매우 높음: NGINX 설정 노출 의심됨

---

## 🔍 취약 조건
본 PoC가 작동하기 위해서는 다음 조건 중 일부가 만족되어야 합니다:

대상 서버가 Ingress-NGINX 컨트롤러를 외부에서 접근 가능한 상태로 운영 중

auth-url 어노테이션을 필터링 없이 처리하고 있음

요청 Host 헤더에 따른 리버스 프록시 동작이 적용됨

---

## ⚠️ 주의사항
이 스크립트는 보안 점검 및 테스트 목적으로만 사용해야 합니다.

무단 점검은 법적 책임을 초래할 수 있습니다.

취약하다고 판단된 서버는 즉시 보안 패치를 적용하거나 어노테이션 필터링을 적용해야 합니다.

---

## 🔧 대응 방안
ingress-nginx 최신 버전으로 업데이트

auth-url, auth-signin 어노테이션에 대한 사용자 입력 검증 적용

외부 요청에서 설정 주입 가능한 URI 패턴 차단

---

## 📄 참고자료
Nginx Ingress Controller GitHub

CVE 상세정보 - CVE-2025-24514

Ingress-NGINX 취약점 보안 권고

---

## 📫 문의
버그 신고나 제안사항은 email 또는 PR로 남겨주세요.

---

## 📝 License
This project is licensed under the MIT License - see the LICENSE file for details. Copyright (c) 2025 KimJuhyeong95
