# CVE-2025-24201 WebKit Vulnerability Detector (PoC)

This proof-of-concept detects whether a WebKit-based browser is vulnerable to **CVE‑2025‑24201**, a high-severity **out-of-bounds write vulnerability** caused by incorrect capability validation in the WebGL implementation.

## 🔍 Vulnerability Summary

CVE‑2025‑24201 is triggered when a `WebGLRenderingContext` (WebGL 1) allows enabling the constant `PRIMITIVE_RESTART_FIXED_INDEX` (`0x8D69`) — a capability only valid in WebGL 2 — without generating a `GL_INVALID_OPERATION` or `GL_INVALID_ENUM` error.

This misbehavior can lead to memory corruption during draw calls involving index buffers.

## ✅ What This Test Does

The PoC:

1. Creates a **WebGL 1** context via `canvas.getContext("webgl")`.
2. Attempts to **enable** the capability `0x8D69`.
3. Checks the return value of `gl.getError()`.

If no error is returned, the implementation is likely vulnerable.

## 📄 Files

- `index.html` – The standalone HTML file that performs the detection and prints result + internal log to screen.
- `README.md` – This file.

## 🧪 Usage

Simply open the `index.html` file in the browser you want to test.

**Expected results:**

- `🛡️ Safe – error returned` → Not vulnerable
- `✅ VULNERABLE – no error on gl.enable(0x8D69)` → Vulnerable

## ⚠️ Notes

- This is a **non-crashing** PoC. It does **not** attempt to trigger memory corruption, only detects exposure.
- The detection relies on GL behavior and will not trigger on patched WebKit versions (after March 2025).

## 📚 References

- [CVE‑2025‑24201 – NVD](https://nvd.nist.gov/vuln/detail/CVE-2025-24201)
- [WebKit Bug 285858 (patch)](https://bugs.webkit.org/show_bug.cgi?id=285858)
- [Apple Security Update – March 2025](https://support.apple.com/en-us/HT213760)

The_Maxu
