[EN](README.md) | [KR](korean.md)

---

## 📄 개요

이 도구는 로컬 네트워크 상의 AirPlay 기능이 활성화된 기기를 mDNS(Zeroconf)를 통해 자동으로 탐색하고,  
CVE-2025-24132 “zero-click” HTTP RCE 취약점 여부를 테스트합니다.  
탐색된 기기는 간단한 GUI에 표시되며, 기기를 클릭하면 모든 속성 정보를 확인할 수 있습니다.

---

### 요구 사항

* Python 3.7 이상
* PyQt5
* `zeroconf` 패키지 (`pip install zeroconf`)

### 설치

```bash
pip install PyQt5 zeroconf
````

또는

```bash
pip install -r requirements.txt
```

### 사용 방법

```bash
python3 main.py
```

* GUI 창이 열리면 동일 LAN 상의 AirPlay 기기를 자동으로 검색합니다.
* 검색된 기기는 “<기기명> (<IP>)” 형태로 리스트에 추가되며, 처음에는 “Scanning…” 상태를 가집니다.
* RCE 테스트가 완료되면 오른쪽 열이 **Vuln**(취약) 또는 **Safe**(안전)로 변경됩니다.

### 화면 구성

* **왼쪽 열(“Device”)**: `<기기명> (IP 주소)`가 표시됩니다.
* **오른쪽 열(“RCE”)**: 취약 여부가 표시됩니다.
* **기기 항목을 클릭**하면 트리가 확장되어 모든 mDNS TXT 속성이 하위 항목으로 나타납니다
  (예: `deviceid`, `model`, `osvers`, `features`, `srcvers` 등).

### 동작 원리

1. **디스커버리**

   * `zeroconf`로 `_airplay._tcp.local.` 서비스를 검색합니다.
   * `127.*` 주소와 중복된 IP를 필터링합니다.

2. **속성 수집**

   * `info.properties`에서 모든 TXT 레코드를 읽어 Python 딕셔너리에 저장합니다.

3. **RCE 테스트 (CVE-2025-24132)**

   * 가짜 reverse shell plist 데이터를 포함한 HTTP `POST /pairing-init` 요청을 보냅니다.
   * 어떠한 `HTTP` 응답이라도 받으면 취약으로 판단합니다.

4. **GUI 업데이트**

   * Qt 시그널을 사용해 새 행을 추가하고 상태를 업데이트합니다.
   * `self.device_info`에 기기의 전체 정보(TXT 필드 포함)를 저장하여 클릭 시 표시합니다.
