[EN](README.md) | [KR](korean.md)

---

## 📄 Overview

This tool discovers AirPlay-capable devices on your local network via mDNS (Zeroconf) and tests them for the CVE-2025-24132 “zero-click” HTTP RCE vulnerability. Discovered devices are listed in a simple GUI; click a device to view all retrieved properties.

---

### Prerequisites

* Python 3.7+
* PyQt5
* `zeroconf` package (`pip install zeroconf`)

### Installation

```bash
pip install PyQt5 zeroconf
````

or

```bash
pip install -r requirements.txt
```

### Usage

```bash
python3 main.py
```

* The GUI will open and automatically discover any AirPlay devices on the same LAN.
* Each discovered device shows as “<DeviceName> (<IP>)” with an initial “Scanning…” status.
* Once the RCE test completes, the right-hand column will update to **Vuln** (vulnerable) or **Safe**.

### Interface

* **Left column (“Device”)**: displays `<name> (IP address)`.
* **Right column (“RCE”)**: shows vulnerability status.
* **Single-click** a device row to expand and view all mDNS TXT properties
  (e.g. `deviceid`, `model`, `osvers`, `features`, `srcvers`, etc.).

### How It Works

1. **Discovery**:

   * Uses `zeroconf` to browse `_airplay._tcp.local.` services.
   * Filters out `127.*` addresses and duplicates.

2. **Property Extraction**:

   * Reads all TXT records (`info.properties`) into a dictionary.

3. **RCE Test (CVE-2025-24132)**:

   * Crafts an HTTP `POST /pairing-init` with a dummy reverse-shell plist.
   * Marks the device as vulnerable if **any** `HTTP` response is received.

4. **GUI Update**:

   * Emits Qt signals to add a new row and later update its status.
   * Stores each device’s full info (including TXT fields) in `self.device_info`.

