# PoC: Exfiltración de Archivos en iOS vía Manipulación de Backup 

**ADVERTENCIA MUY IMPORTANTE: ESTE SOFTWARE ES UNA PRUEBA DE CONCEPTO (PoC) CON FINES EDUCATIVOS Y DE INVESTIGACIÓN EN SEGURIDAD ÚNICAMENTE.**

* **NO UTILICES este script en dispositivos para los que no tengas consentimiento explícito y por escrito del propietario.** El acceso no autorizado a sistemas informáticos es ilegal en la mayoría de las jurisdicciones.
* **Este script implica la RESTAURACIÓN de un dispositivo iOS desde una copia de seguridad, lo que resultará en la PÉRDIDA TOTAL DE LOS DATOS ACTUALES en el dispositivo.** Procede con extrema precaución y solo en dispositivos de prueba dedicados.
* El autor/proveedor de este script no se hace responsable del mal uso o de cualquier daño o pérdida de datos causada por el uso de este software. ÚSALO BAJO TU PROPIO RIESGO.

---

## Descripción General

Este script de Python demuestra una vulnerabilidad (hipotética o basada en vulnerabilidades pasadas, referenciada aquí de forma ilustrativa como "anterior a iOS 18.3" según el PoC original) que permite la exfiltración de archivos arbitrarios de un dispositivo iOS. El método se basa en la manipulación de una copia de seguridad del dispositivo, la creación de un enlace simbólico (symlink) malicioso dentro de esa copia, y luego la restauración de esta copia modificada en el dispositivo. Finalmente, se interactúa con un servicio del sistema (`com.apple.mobile.MCInstall`) para que, sin saberlo, lea el archivo apuntado por el symlink.

Este script ha sido "mejorado" desde la perspectiva de un investigador de seguridad para incluir:
* Logging detallado.
* Parametrización vía argumentos de línea de comandos.
* Comprobaciones de dependencias y versión de iOS (conceptual).
* Comentarios extensos sobre el funcionamiento interno y posibles mitigaciones.
* Mayor robustez y manejo de errores.

## Vulnerabilidad Explicada (Conceptual)

La vulnerabilidad explotada se aprovecha de la siguiente cadena de debilidades (presentes en versiones antiguas de iOS):

1.  **Creación de Symlinks en Copias de Seguridad:** La capacidad de crear un archivo de copia de seguridad donde un archivo de sistema esperado (ej. `CloudConfigurationDetails.plist`) es reemplazado por un enlace simbólico que apunta a un archivo sensible en el sistema de archivos del dispositivo (ej. `/private/etc/passwd`).
2.  **Restauración de Symlinks:** El proceso de restauración de iOS, en versiones vulnerables, restauraba estos enlaces simbólicos en el dispositivo sin una validación o saneamiento adecuados.
3.  **Lectura por Servicio Privilegiado:** Un servicio del sistema (`com.apple.mobile.MCInstall` en este PoC) que tiene permisos para leer el archivo de configuración original (`CloudConfigurationDetails.plist`) puede ser invocado. Al intentar leer el archivo, el sistema operativo sigue el enlace simbólico y, en su lugar, lee el contenido del archivo sensible al que apunta el symlink.
4.  **Exfiltración de Datos:** El servicio devuelve el contenido del archivo leído (que es el archivo sensible) al cliente que lo solicitó.

**Nota sobre la Versión de iOS:** El PoC original menciona "iOS < 18.3". Esta numeración es atípica. Apple ha parchado vulnerabilidades relacionadas con el manejo de symlinks en copias de seguridad y perfiles de configuración en versiones de iOS significativamente anteriores (generalmente antes de iOS 15/16 para los vectores más directos de este tipo). Esta referencia de versión se mantiene por consistencia con el origen del script, pero debe entenderse como ilustrativa de "una versión vulnerable no parchada".

## Características del Script Mejorado

* **Logging Detallado:** Timestamps y mensajes claros para cada paso del proceso.
* **Argumentos de Línea de Comandos:** Configuración flexible de directorios, archivo objetivo, UDID, etc.
* **Modularidad:** Posibilidad de omitir fases (backup/restauración o explotación) para análisis.
* **Comprobación de Dependencias:** Verifica la existencia de `idevicebackup2`.
* **Información del Dispositivo:** Intenta obtener la versión de iOS y UDID.
* **Comprobación de Vulnerabilidad (Conceptual):** Advierte si la versión de iOS detectada probablemente esté parchada.
* **Manejo de Errores Mejorado:** Captura y reporta errores de forma más clara.
* **Comentarios Educativos:** Explicaciones detalladas en el código sobre el proceso y mitigaciones.

## Requisitos Previos

* **Python 3.7+**
* **libimobiledevice:** Un conjunto de herramientas para interactuar con dispositivos iOS. Específicamente, se necesita `idevicebackup2` en el PATH del sistema.
    * En macOS: `brew install libimobiledevice`
    * En Linux: `sudo apt-get install libimobiledevice-utils` (el nombre del paquete puede variar)
* **Paquetes de Python:**
    ```bash
    pip install usbmux-python python-lockdown packaging
    ```

## Instalación

1.  Clona este repositorio:
    ```bash
    git clone <url-del-repositorio>
    cd <nombre-del-directorio>
    ```
2.  Asegúrate de tener `libimobiledevice` instalado y `idevicebackup2` accesible.
3.  Instala las dependencias de Python:
    ```bash
    pip install -r requirements.txt # (Si creas un requirements.txt con usbmux-python, python-lockdown, packaging)
    # o manualmente:
    # pip install usbmux-python python-lockdown packaging
    ```

## Uso

```bash
./exploit_ios_file_read.py [OPCIONES]
