# CVE-2025-24076

# Microsoft Windows Cross Device Service Elevation of Privilege Vulnerability Exploit

---

## Overview

This script exploits a vulnerability in the **Windows Cross Device Service** that allows privilege escalation on **Windows 11**, **Windows Server 2025**, and **Windows Server 2022 23H2 (Server Core installation)** systems.

- **CVE:** CVE-2025-24076  
- **CVSS v3.1 Score:** 7.3 (Important)  
- **Type:** Elevation of Privilege  
- **Weakness:** CWE-284 - Improper Access Control  
- **Attack Vector:** Local  
- **Privileges Required:** Low  
- **User Interaction:** Required  

---

## Description

The vulnerability stems from improper access control in the Windows Cross Device Service, allowing a low-privileged local attacker to overwrite a critical DLL file (`CrossDevice.Streaming.Source.dll`) located in a writable directory.

When the user opens the Windows "Mobile devices" Settings page, the system loads this DLL. If the attacker replaces it with a malicious DLL, the code executes with SYSTEM privileges, resulting in full privilege escalation.

---

## Affected Systems

- Windows 11 Versions 24H2, 23H2, 22H2 (x64 and ARM64)  
- Windows Server 2025  
- Windows Server 2022 23H2 (Server Core installation)  

---

## Exploitation Steps

1. Check for the presence of the target DLL in the writable directory.  
2. Build a malicious DLL that executes code with SYSTEM privileges on load.  
3. Backup the original DLL to allow recovery.  
4. Prompt the user to open the "Mobile devices" Settings page to trigger DLL loading.  
5. Monitor the DLL file until it is unlocked, then replace it with the malicious DLL.  
6. Achieve SYSTEM privileges once the malicious DLL is loaded by the system.  

---

## Usage Instructions

1. Ensure you have `gcc` (MinGW) installed for compiling the malicious DLL from C source code.  
2. Run the Python script as a low-privileged user.  
3. Follow the on-screen instructions to open the Windows Settings page as requested.  
4. Check for the file `C:\poc_only_admin_can_write_to_c.txt` as confirmation of successful exploitation.


---

## Warnings and Legal Notice

- This exploit is provided for educational and research purposes only.  
- Unauthorized use on systems without explicit permission is illegal and punishable by law.  
- Use this exploit only on systems you own or in a controlled lab environment.  

---

## Updates

Keep your systems patched by applying official Microsoft updates to mitigate this vulnerability.

---

## Script Details

The exploit script is written in Python and uses `gcc` (MinGW) to compile a malicious DLL. It performs DLL replacement after detecting that the original DLL is unlocked, triggering privilege escalation once the malicious DLL is loaded by the system.

---

If you need help running the script or further explanations, feel free to ask! 😊

---

## Author

- **Name:** Mohammed Idrees Banyamer  
- **Instagram:** [@banyamer_security](https://instagram.com/banyamer_security)  
- **GitHub:** [https://github.com/mbanyamer](https://github.com/mbanyamer)  
- **Country:** Jordan  
- **Date:** 2025-06-06  
