# CVE-2025-24054 and CVE-2025-24071 - NTLM Hash Leak via .library-ms Exploit

![PoC](https://img.shields.io/badge/type-poc-blue)

This PoC demonstrates the exploitation of the NTLM hash leak via `.library-ms` files on unpatched Windows systems (March 2025 Patch Tuesday).

> ⚠️ This is for educational and research purposes only. Do not use this on production or unauthorized systems.

## 🧠 Description

When a `.library-ms` file with a UNC path is opened (or previewed) in Windows Explorer, it triggers an SMB authentication request to the specified server, leaking the NTLMv2 hash.

## 📁 Files

- `generate_library_ms.py` : generates the malicious `.library-ms` file
- `xd.library-ms` : sample malicious file (points to a configurable SMB server)
- `Instructions_Responder.md` : how to set up a fake SMB server with Responder

## 🧪 How to Test

1. Start `Responder` on your attacker machine:
   ```bash
   sudo responder -I eth0
   ```

2. On the victim Windows VM:
   - Download or generate the `.library-ms` file
   - Preview it in File Explorer

3. On the attacker side:
   - Observe the captured NTLM hash in Responder's output

## 📸 Demo

![PoC Demo](./Screenshots/poc-demo.png)

## 📚 References

- [Check Point Research – CVE-2025-24054 Analysis](https://research.checkpoint.com/2025/cve-2025-24054-ntlm-exploit-in-the-wild/)
- [Microsoft Patch Notes (March 2025)](https://borncity.com/win/2025/04/22/windows-ntlm-vulnerability-cve-2025-24054-is-being-exploited/)

## ✅ Mitigation

- Apply Microsoft's March 2025 patches
- Disable NTLM where possible
- Educate users to avoid interacting with `.library-ms` files from untrusted sources

## 🧑‍💻 Author

PoC created by [Helidem](https://github.com/helidem)
