const express = require('express');
const http = require('http');
const app = express();
const PORT = 8989;

// Middleware to log raw HTTP request
app.use((req, res, next) => {
  console.log(`\n--- Incoming Request ---`);
  console.log(`${req.method} ${req.originalUrl}`);
  console.log('Headers:', req.headers);

  let body = [];
  req.on('data', chunk => {
    body.push(chunk);
  });

  req.on('end', () => {
    if (body.length > 0) {
      console.log('Body:', Buffer.concat(body).toString());
    }
    next();
  });
});

// Only allow /
app.get('/', (req, res) => {
  res.send('Hello from vulnerable Express server on Node.js v20!\n');
});

// 404 handler for all other routes
app.use((req, res) => {
  res.status(404).send('Not Found\n');
});

const server = http.createServer(app);

server.listen(PORT, () => {
  console.log(`Vulnerable Express server running on http://localhost:${PORT}`);
});