# CVE-2025-23061 - Mongoose Command Injection

A proof of concept for the Command Injection vulnerability in Mongoose < 8.9.5 affecting the `populate()` function's match option.

## Vulnerability Details

**CVE ID:** CVE-2025-23061  
**Severity:** CRITICAL (CVSS 9.0)  
**Affected Package:** mongoose  
**Vulnerable Versions:** 
- < 6.13.6
- >= 7.0.0 < 7.8.4
- >= 8.0.0 < 8.9.5


## CVE-2024-53900 & CVE-2025-23061 Timeline
- November 7, 2024:  Dat Phung identified a critical vulnerability in Mongoose and submitted a security report to Snyk. 
- November 26, 2024: Mongoose released version 8.8.3 to address and fix this vulnerability. 
- December 2, 2024: The National Vulnerability Database (NVD) disclosed CVE-2024-53900 for this vulnerability. 
- December 17, 2024: Upon analyzing Mongoose’s 8.8.3 patch, Dat Phung found a bypass that still enabled RCE (Remote Code Execution). A detailed security report was submitted to Tidelift. 
- January 13, 2025: Mongoose released version 8.9.5, introducing an enhanced patch that effectively addressed the bypass. 
- January 15, 2025: The National Vulnerability Database (NVD) officially disclosed CVE-2025-23061, emphasizing the severity of the newly identified vulnerability.

### Root Cause

This vulnerability exists due to an incomplete fix for CVE-2024-53900. While direct `$where` injection is blocked, attackers can bypass this protection by nesting `$where` operators within logical operators like `$and`, `$or`, etc.

The vulnerable code path:
1. User provides input through `populate()` match parameter
2. Application uses unsanitized user input directly in the match query
3. Mongoose fails to sanitize `$where` when nested inside logical operators
4. Attacker executes arbitrary JavaScript on MongoDB server

## Impact

- **Information Disclosure:** Access sensitive data without proper authorization
- **Authentication Bypass:** Retrieve admin-only information
- **Arbitrary Code Execution:** Execute JavaScript on MongoDB server
- **Data Modification:** Potential to modify database records

## Setup & Running the PoC

### Prerequisites

- Node.js >= 14
- MongoDB running locally or accessible via connection string

### Installation

```bash
# Install dependencies
npm install

# Optional: Use specific MongoDB URI
export MONGODB_URI="mongodb://localhost:27017/mongoose_cve_poc"
```

### Run the Vulnerable Server

```bash
npm start
```

The server will start on `http://localhost:3000`

### Run the Exploit

In another terminal:

```bash
node exploit.js
```

## References

- [GitHub Commit (Fix)](https://github.com/Automattic/mongoose/commit/64a9f9706f2428c49e0cfb8e223065acc645f7bc)
- [Mongoose Release 8.9.5](https://github.com/Automattic/mongoose/releases/tag/8.9.5)
- [NVD CVE-2025-23061](https://nvd.nist.gov/vuln/detail/CVE-2025-23061)
- [Nuclei Template](https://github.com/projectdiscovery/nuclei-templates/blob/main/http/cves/2025/CVE-2025-23061.yaml)
- [Mongoose CVE Lab](https://github.com/NamhyeonKo/mongoose-cve-lab)
- [POC](https://www.opswat.com/blog/technical-discovery-mongoose-cve-2025-23061-cve-2024-53900)
## Disclaimer

This PoC is provided for educational purposes only. Unauthorized access to computer systems is illegal. Use this only on systems you own or have explicit permission to test.


