# PoC – CVE-2025-22870 – HTTP Proxy Bypass via IPv6 Zone ID in Go

## Summary

This Proof of Concept demonstrates the exploitation of CVE-2025-22870, a vulnerability in the `golang.org/x/net/http/httpproxy` package (prior to v0.36.0), which can be used to bypass HTTP proxy restrictions by abusing the way IPv6 zone identifiers are matched against NO_PROXY patterns.

## Vulnerable Component

- **Package**: `golang.org/x/net/http/httpproxy`
- **Affected Versions**: < 0.36.0
- **Patched Version**: 0.36.0
- **Discovered by**: Juho Forsén (Mattermost)
- **Go Issue**: https://go.dev/issue/71984
- **GitHub Advisory**: https://github.com/advisories/GHSA-qxp5-gwg8-xv66

## Vulnerability Description

When the `NO_PROXY` environment variable is set to restrict certain domains from being routed through a proxy (e.g., `NO_PROXY=*.example.com`), a specially crafted request to a host with an **IPv6 zone ID** (e.g., `[::1%25.example.com]`) may **incorrectly match** and avoid being proxied. This results in **proxy bypass**, which could allow **Server-Side Request Forgery (SSRF)** under certain conditions.

## Impact

This vulnerability can be leveraged to send requests directly to internal or local services **while evading configured proxies**, even if domains were supposedly protected by `NO_PROXY`.

## Vulnerability Details

The PoC exploits a vulnerability in the `golang.org/x/net/http/httpproxy` package, specifically in the way it parses IPv6 zone identifiers when matching against `NO_PROXY` rules.

The payload used is:

```go
[::1%25.example.com]:7777
```

Due to the parsing bug in the vulnerable package, this address bypasses the proxy despite matching NO_PROXY.

