package main

import (
	"fmt"
	"io"
	"net/http"
	"os"
)

func main() {
	os.Setenv("HTTP_PROXY", "http://127.0.0.1:8080")
	os.Setenv("NO_PROXY", "*.example.com")

	client := &http.Client{}

	resp, err := client.Get("http://[::1%25.example.com]:7777")
	if err != nil {
		fmt.Println("Error:", err)
		return
	}
	defer resp.Body.Close()

	body, _ := io.ReadAll(resp.Body)
	fmt.Println(string(body))
}