# 🚨 CVE-2025-2266 — WordPress Plugin Exploit

## 🔍 Vulnerability Summary

The **Checkout Mestres do WP for WooCommerce** plugin for WordPress is affected by an **unauthenticated arbitrary options update vulnerability** in versions `8.6.5` through `8.7.5`.

The vulnerable function `cwmpUpdateOptions()` lacks proper capability checks, allowing **unauthenticated attackers** to update arbitrary WordPress options.

### ⚠️ Risk & Exploitation

An attacker can:
- Enable user registration
- Set the default role to `administrator`
- Register a new account that will automatically gain **admin privileges**

---

## 🧨 Vulnerability Details

- **CVE ID**: CVE-2025-2266
- **CVSS Score**: 9.8 (Critical)
- **Vector**: Missing Authorization
- **CVSS Vector String**: `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`
- **Published**: March 28, 2025
- **Last Updated**: March 29, 2025

---

## ⚙️ Exploit Script Overview

This Python script exploits the vulnerability to:
1. Enable registration + assign `administrator` as the default role
2. Register a new user of your choice
3. Provide login details and instructions for privilege access

---

## 🧾 Requirements

- Python 3.x installed 🐍
- `requests` module (install via `pip install requests`)
- WordPress site with the vulnerable plugin installed (`8.6.5` – `8.7.5`)

---

## 🧠 How It Works

1. The script checks the plugin version via:
   ```
   /wp-content/plugins/checkout-mestres-wp/readme.txt
   ```

2. If the plugin is vulnerable:
   - It sends a POST request to the plugin's exposed AJAX function
   - Modifies WordPress options without authentication

3. Registers a new user (default: `nxploited`) with administrator privileges

---

## 🛠️ Usage

```bash
python CVE-2025-2266.py -u http://target.com/wordpress -newuser adminx -email hacker@evil.com
```

### Optional Parameters:
| Option           | Description                                                   |
|------------------|---------------------------------------------------------------|
| `-u`, `--url`     | Target WordPress site URL (Required)                         |
| `-newuser`        | Create new admin user (default username: `nxploited`)        |
| `-email`          | Email for new user (default: `nxploitbot@gmail.com`)         |

---

## 📌 Full Help Message

```bash
usage: CVE-2025-2266.py [-h] -u URL [-newuser [NEWUSER]] [-email [EMAIL]]

CVE-2025-2266 Checkout Mestres do WP for WooCommerce Plugin Exploit
By : Nxploited | Khaled Alenazi

options:
  -h, --help          show this help message and exit
  -u, --url URL       Target WordPress site URL (e.g., http://example.com/wordpress)
  -newuser [NEWUSER]  Create new admin user (default username: nxploited)
  -email [EMAIL]      Email for new user (default: nxploitbot@gmail.com)
```

---

## 🔐 After Exploitation

Once the user is created:

1. Visit the login page:
   ```
   http://target.com/wordpress/wp-login.php
   ```

2. Click on **"Lost your password?"**
   - Enter the email used (e.g., `nxploitbot@gmail.com`)
   - WordPress will send a reset link

3. Set a password and gain full admin access 🎯

---

## 👨‍💻 Author

**Exploit by Nxploited | Khaled Alenazi**

---

⚠️ *This script is for educational and authorized testing purposes only.*
